/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug300572Small2
extends AbstractProvisioningTest {
    IInstallableUnit featureBeingPatched;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch p2;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IMetadataRepository repo = Bug300572Small2.getMetadataRepositoryManager().loadRepository(Bug300572Small2.getTestData("bug300572 data", "testData/bug300572Small/repo/").toURI(), (IProgressMonitor)new NullProgressMonitor());
        this.featureBeingPatched = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"hellofeature.feature.group"), null).iterator().next();
        this.p1 = (IInstallableUnitPatch)repo.query(QueryUtil.createIUQuery((String)"hellopatch.feature.group", (Version)Version.create((String)"1.0.0")), null).iterator().next();
        this.p2 = (IInstallableUnitPatch)repo.query(QueryUtil.createIUQuery((String)"hellopatch.feature.group", (Version)Version.create((String)"1.0.2.201001211536")), null).iterator().next();
        this.planner = Bug300572Small2.createPlanner();
        this.engine = Bug300572Small2.createEngine();
    }

    public void testInstall() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.featureBeingPatched});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small2.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP1() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.featureBeingPatched, this.p1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small2.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.featureBeingPatched, this.p2});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small2.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP1AndP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.featureBeingPatched, this.p1, this.p2});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small2.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP1ThenP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.featureBeingPatched, this.p1});
        req1.setInstallableUnitInclusionRules((IInstallableUnit)this.p1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small2.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        Bug300572Small2.assertContains(plan1.getAdditions().query(QueryUtil.ALL_UNITS, null), this.p1);
        Bug300572Small2.assertFalse((boolean)plan1.getAdditions().query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.1.200911201237")), null).isEmpty());
        Bug300572Small2.assertOK("plan execution", this.engine.perform(plan1, null));
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p2});
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p2));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        Bug300572Small2.assertOK("Planning for installing P2", plan2.getStatus());
        Bug300572Small2.assertContains(plan2.getAdditions().query(QueryUtil.ALL_UNITS, null), this.p2);
        Bug300572Small2.assertFalse((boolean)plan2.getAdditions().query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.2.201001211536")), null).isEmpty());
    }
}

