/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug309530
extends AbstractProvisioningTest {
    private File previousStoreValue = null;
    private IProfile profile;

    protected String getTestDataPath() {
        return "testData/bug309530";
    }

    @Override
    protected void tearDown() throws Exception {
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        profileStore.set(realProfileRegistry, this.previousStoreValue);
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug309530.getTestData("loading planner test data", this.getTestDataPath());
        File tempFolder = this.getTempFolder();
        Bug309530.copy("0.2", reporegistry1, tempFolder);
        IProfileRegistry realProfileRegistry = this.getProfileRegistry();
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        this.previousStoreValue = (File)profileStore.get(realProfileRegistry);
        profileStore.set(realProfileRegistry, new File(tempFolder, "p2/org.eclipse.equinox.p2.engine/profileRegistry"));
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        this.profile = realProfileRegistry.getProfile("PlatformProfile");
        Bug309530.assertNotNull((Object)this.profile);
    }

    public void testInstall() {
        IPlanner planner = Bug309530.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(this.profile);
        String[] ids = new String[]{"hi", "b"};
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            IInstallableUnit iu = (IInstallableUnit)this.profile.query(QueryUtil.createIUQuery((String)id), (IProgressMonitor)new NullProgressMonitor()).iterator().next();
            changeRequest.remove(iu);
            ++i;
        }
        int origsize = changeRequest.getInstallableUnitProfilePropertiesToAdd().size();
        int i2 = 0;
        while (i2 < 5) {
            IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, (IProgressMonitor)new NullProgressMonitor());
            IQueryable result = plan.getRemovals();
            IQueryResult r = result.query(QueryUtil.ALL_UNITS, this.getMonitor());
            Bug309530.assertFalse((String)("1.0." + i2), (boolean)r.isEmpty());
            Bug309530.assertEquals((String)("1.1." + i2), (int)origsize, (int)changeRequest.getInstallableUnitProfilePropertiesToAdd().size());
            ++i2;
        }
    }
}

