/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class EPPPackageInstallStability_bug323322
extends AbstractProvisioningTest {
    public void testInstallEppJavaPackage() throws ProvisionException {
        IProvisioningAgentProvider provider = EPPPackageInstallStability_bug323322.getAgentProvider();
        IProvisioningAgent agent = provider.createAgent(this.getTempFolder().toURI());
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        repoMgr.addRepository(EPPPackageInstallStability_bug323322.getTestData("Helios SR0", "testData/helios-sr0/").toURI());
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        HashMap<String, String> profileArgs = new HashMap<String, String>();
        profileArgs.put("osgi.os", "linux");
        profileArgs.put("osgi.ws", "gtk");
        profileArgs.put("osgi.arch", "x86");
        HashSet<IInstallableUnit> iusFromFirstResolution = new HashSet<IInstallableUnit>();
        IProfile eppProfile1 = ((IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)).addProfile("epp.install.1", profileArgs);
        IProfileChangeRequest request = planner.createChangeRequest(eppProfile1);
        request.add((IInstallableUnit)repoMgr.query(QueryUtil.createIUQuery((String)"epp.package.java"), null).iterator().next());
        ProvisioningContext pc = new ProvisioningContext(agent);
        IProvisioningPlan plan = planner.getProvisioningPlan(request, pc, (IProgressMonitor)new NullProgressMonitor());
        EPPPackageInstallStability_bug323322.assertOK("plan is not ok", plan.getStatus());
        Set tmp = plan.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).query(QueryUtil.ALL_UNITS, null).toSet();
        for (IInstallableUnit iu : tmp) {
            iusFromFirstResolution.add(iu.unresolved());
        }
        IProfile eppProfile2 = ((IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)).addProfile("epp.install.2", profileArgs);
        request = planner.createChangeRequest(eppProfile2);
        request.add((IInstallableUnit)repoMgr.query(QueryUtil.createIUQuery((String)"epp.package.java"), null).iterator().next());
        pc = new ProvisioningContext(agent);
        pc.setMetadataRepositories(new URI[0]);
        pc.setArtifactRepositories(new URI[0]);
        pc.setExtraInstallableUnits(new ArrayList(iusFromFirstResolution));
        plan = planner.getProvisioningPlan(request, pc, (IProgressMonitor)new NullProgressMonitor());
        EPPPackageInstallStability_bug323322.assertOK("plan is not ok", plan.getStatus());
        tmp = plan.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).query(QueryUtil.ALL_UNITS, null).toSet();
        HashSet<IInstallableUnit> iusFromSecondResolution = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : tmp) {
            iusFromSecondResolution.add(iu.unresolved());
        }
        EPPPackageInstallStability_bug323322.assertEquals((int)iusFromFirstResolution.size(), (int)iusFromSecondResolution.size());
    }
}

