/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class InclusionRuleTest2
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IProfile profile;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = InclusionRuleTest2.createIU("A", Version.create((String)"1.0.0"), true);
        InclusionRuleTest2.createIU("A", Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, true, MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)VersionRange.emptyRange, (int)0, (String)"foo bar"), null);
        this.a2 = InclusionRuleTest2.createIU("A", Version.create((String)"2.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = InclusionRuleTest2.createPlanner();
        this.engine = InclusionRuleTest2.createEngine();
    }

    public void testChangeIUProperty() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        req.setInstallableUnitProfileProperty(this.a1, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        InclusionRuleTest2.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        InclusionRuleTest2.assertProfileContainsAll("A1 is missing", this.profile, new IInstallableUnit[]{this.a1});
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        this.profile = profileRegistry.getProfile(this.profile.getProfileId());
        IQueryResult c = this.profile.query((IQuery)new UserVisibleRootQuery(), null);
        InclusionRuleTest2.assertEquals((int)InclusionRuleTest2.queryResultSize(c), (int)1);
        System.gc();
        ProfileChangeRequest req2 = ProfileChangeRequest.createByProfileId((IProvisioningAgent)InclusionRuleTest2.getAgent(), (String)this.profile.getProfileId());
        req2.removeInstallableUnits(new IInstallableUnit[]{this.a1});
        req2.addInstallableUnits(new IInstallableUnit[]{this.a2});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        InclusionRuleTest2.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        InclusionRuleTest2.assertInstallOperand(plan2, this.a2);
        this.engine.perform(plan2, null);
        this.profile = this.getProfile(this.profile.getProfileId());
        InclusionRuleTest2.assertProfileContains("A2 is missing", this.profile, new IInstallableUnit[]{this.a2});
    }
}

