/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class NoUnecessaryIUProperty
extends AbstractProvisioningTest {
    IProfile profile1;
    IPlanner planner;
    IEngine engine;
    IMetadataRepository repo;
    IInstallableUnit iuA;
    IInstallableUnit iuB;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = NoUnecessaryIUProperty.createPlanner();
        this.engine = NoUnecessaryIUProperty.createEngine();
        this.iuA = NoUnecessaryIUProperty.createIU("A");
        this.iuB = NoUnecessaryIUProperty.createIU("B");
    }

    public void testIUExtraneousPlanEntry() {
        IProfileChangeRequest pcr = this.planner.createChangeRequest(this.profile1);
        pcr.add(this.iuA);
        pcr.setInstallableUnitProfileProperty(this.iuB, "theKey", "theValue");
        IProvisioningPlan plan = this.planner.getProvisioningPlan(pcr, null, (IProgressMonitor)new NullProgressMonitor());
        NoUnecessaryIUProperty.assertEquals((int)2, (int)((ProvisioningPlan)plan).getOperands().length);
    }

    public void testZeroOperands() {
        IProfileChangeRequest pcr = this.planner.createChangeRequest(this.profile1);
        pcr.setInstallableUnitProfileProperty(this.iuB, "theKey", "theValue");
        IProvisioningPlan plan = this.planner.getProvisioningPlan(pcr, null, (IProgressMonitor)new NullProgressMonitor());
        NoUnecessaryIUProperty.assertEquals((int)0, (int)((ProvisioningPlan)plan).getOperands().length);
    }
}

