/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest2
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch p2;
    IInstallableUnitPatch p3;
    IInstallableUnitPatch p4;
    IInstallableUnitPatch p5;
    IInstallableUnitPatch p6;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IProvidedCapability[] cap = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"foo", (String)"bar", (Version)Version.createOSGi((int)1, (int)0, (int)0))};
        this.a1 = PatchTest2.createIU("A", Version.create((String)"1.0.0"), null, new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false)}, cap, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, null);
        this.b1 = PatchTest2.createIU("B", Version.createOSGi((int)1, (int)2, (int)0), true);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p1 = PatchTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.1.0]"), null, (boolean)false, (boolean)false, (boolean)false)}}, null);
        this.p2 = PatchTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.3.0, 1.5.0]"), null, (boolean)false, (boolean)false, (boolean)false)}}, null);
        this.p3 = PatchTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.1.0]"), null, (boolean)false, (boolean)false, (boolean)false)}, {MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.3.0, 1.5.0]"), null, (boolean)false, (boolean)false, (boolean)false)}}, null);
        this.p4 = PatchTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.6.0, 1.7.0]"), null, (boolean)false, (boolean)false, (boolean)false)}, {MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.3.0, 1.5.0]"), null, (boolean)false, (boolean)false, (boolean)false)}}, null);
        this.p5 = PatchTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"foo", (String)"bar", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.5.0]"), null, (boolean)false, (boolean)false, (boolean)false)}}, null);
        this.p6 = PatchTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[0][], null);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest2.createPlanner();
        this.engine = PatchTest2.createEngine();
    }

    public void testPatchScope() {
        ProfileChangeRequest req8 = new ProfileChangeRequest(this.profile1);
        req8.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p6});
        IProvisioningPlan plan8 = this.planner.getProvisioningPlan((IProfileChangeRequest)req8, null, null);
        PatchTest2.assertEquals((int)0, (int)plan8.getStatus().getSeverity());
        ProfileChangeRequest req6 = new ProfileChangeRequest(this.profile1);
        req6.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p5});
        IProvisioningPlan plan6 = this.planner.getProvisioningPlan((IProfileChangeRequest)req6, null, null);
        PatchTest2.assertEquals((int)0, (int)plan6.getStatus().getSeverity());
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        PatchTest2.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p2});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        PatchTest2.assertEquals((int)4, (int)plan3.getStatus().getSeverity());
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.profile1);
        req4.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p3});
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        PatchTest2.assertEquals((int)0, (int)plan4.getStatus().getSeverity());
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile1);
        req5.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p4});
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        PatchTest2.assertEquals((int)4, (int)plan5.getStatus().getSeverity());
    }

    public void testExplanation3() {
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p2});
        ProvisioningPlan plan3 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        PatchTest2.assertEquals((int)4, (int)plan3.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan3.getStatus()).getRequestStatus();
        PatchTest2.assertEquals((int)1, (int)requestStatus.getShortExplanation());
        Set conflictingRoot = requestStatus.getConflictsWithInstalledRoots();
        PatchTest2.assertTrue((boolean)conflictingRoot.contains(this.a1));
        PatchTest2.assertEquals((int)1, (int)conflictingRoot.size());
    }

    public void testExplanation5() {
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile1);
        req5.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p4});
        ProvisioningPlan plan5 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        PatchTest2.assertEquals((int)4, (int)plan5.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan5.getStatus()).getRequestStatus();
        PatchTest2.assertEquals((int)1, (int)requestStatus.getShortExplanation());
        Set conflictingRoot = requestStatus.getConflictsWithInstalledRoots();
        PatchTest2.assertTrue((boolean)conflictingRoot.contains(this.a1));
        PatchTest2.assertEquals((int)1, (int)conflictingRoot.size());
    }
}

