/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PropertyMatchRequirement
extends AbstractProvisioningTest {
    private IInstallableUnit providerIu;
    private IInstallableUnit consumerIu;
    private IProfile profile;
    private IPlanner planner;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String osgiService = "osgi.service";
        String objectClass = "objectClass";
        List<String> objectClassList = Arrays.asList("org.example.A", "org.example.B", "org.example.C");
        HashMap<String, Object> capability = new HashMap<String, Object>();
        capability.put(osgiService, "ignored-1");
        capability.put(objectClass, objectClassList);
        IProvidedCapability[] provides = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)osgiService, capability)};
        this.providerIu = PropertyMatchRequirement.createIU("provider", DEFAULT_VERSION, provides);
        String requirement = String.format("(%s=%s)", objectClass, objectClassList.get(0));
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)osgiService, (String)requirement, null, (int)1, (int)1, (boolean)true)};
        this.consumerIu = PropertyMatchRequirement.createIU("consumer", DEFAULT_VERSION, requires);
        this.profile = this.createProfile("test." + this.getName());
        this.planner = PropertyMatchRequirement.createPlanner();
    }

    public void testMandatoryPresent() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.providerIu, this.consumerIu});
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.add(this.consumerIu);
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        PropertyMatchRequirement.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        PropertyMatchRequirement.assertInstallOperand(plan, this.consumerIu);
        PropertyMatchRequirement.assertInstallOperand(plan, this.providerIu);
    }

    public void testMandatoryAbsent() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.consumerIu});
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.add(this.consumerIu);
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        PropertyMatchRequirement.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        IRequirement consumerReq = (IRequirement)this.consumerIu.getRequirements().iterator().next();
        requestStatus.getExplanations().stream().filter(e -> e instanceof Explanation.MissingIU).filter(e -> ((Explanation.MissingIU)e).req.toString().equals(consumerReq.toString())).findFirst().orElseGet(() -> {
            PropertyMatchRequirement.fail((String)("Did not find explanation for missing requirement: " + consumerReq));
            return null;
        });
        PropertyMatchRequirement.assertNoOperand(plan, this.consumerIu);
    }
}

