/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ProvisioningPlanQueryTest
extends AbstractProvisioningTest {
    private static final String TESTPROFILE = "test";

    public void testNull() {
        IQueryResult c = new ProvisioningPlan(Status.OK_STATUS, this.getProfile(TESTPROFILE), null, null).getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        ProvisioningPlanQueryTest.assertTrue((boolean)c.isEmpty());
    }

    public void testAddition() {
        Operand[] ops = new Operand[]{new InstallableUnitOperand(null, ProvisioningPlanQueryTest.createIU("A"))};
        IQueryResult c = new ProvisioningPlan(this.getProfile(TESTPROFILE), ops, null).getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        ProvisioningPlanQueryTest.assertEquals((int)1, (int)ProvisioningPlanQueryTest.queryResultSize(c));
        ProvisioningPlanQueryTest.assertTrue((boolean)new ProvisioningPlan(this.getProfile(TESTPROFILE), ops, null).getRemovals().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
    }

    public void testRemoval() {
        Operand[] ops = new Operand[]{new InstallableUnitOperand(ProvisioningPlanQueryTest.createIU("A"), null)};
        IQueryResult c = new ProvisioningPlan(this.getProfile(TESTPROFILE), ops, null).getRemovals().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        ProvisioningPlanQueryTest.assertEquals((int)1, (int)ProvisioningPlanQueryTest.queryResultSize(c));
        ProvisioningPlanQueryTest.assertTrue((boolean)new ProvisioningPlan(this.getProfile(TESTPROFILE), ops, null).getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
    }

    public void testUpdate() {
        Operand[] ops = new Operand[]{new InstallableUnitOperand(ProvisioningPlanQueryTest.createIU("A"), ProvisioningPlanQueryTest.createIU("B"))};
        IQueryResult c = new ProvisioningPlan(this.getProfile(TESTPROFILE), ops, null).getRemovals().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        ProvisioningPlanQueryTest.assertEquals((int)1, (int)ProvisioningPlanQueryTest.queryResultSize(c));
        ProvisioningPlanQueryTest.assertEquals((int)1, (int)ProvisioningPlanQueryTest.queryResultSize(new ProvisioningPlan(this.getProfile(TESTPROFILE), ops, null).getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
    }
}

