/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SDKPatchingTest1
extends AbstractProvisioningTest {
    IProfile profile = null;
    ArrayList<IInstallableUnit> newIUs = new ArrayList();
    IInstallableUnit patchInstallingCommon = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = SDKPatchingTest1.getTestData("test data for sdkpatching test", "testData/sdkpatchingtest");
        File tempFolder = this.getTempFolder();
        SDKPatchingTest1.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(SDKPatchingTest1.getAgent(), tempFolder, null, false);
        this.profile = registry.getProfile("SDKPatchingTest");
        SDKPatchingTest1.assertNotNull((Object)this.profile);
        MetadataFactory.InstallableUnitDescription newCommon = SDKPatchingTest1.createIUDescriptor((IInstallableUnit)this.profile.query(QueryUtil.createIUQuery((String)"org.eclipse.equinox.common"), (IProgressMonitor)new NullProgressMonitor()).iterator().next());
        Version newVersionCommon = Version.createOSGi((int)3, (int)5, (int)0, (String)"zeNewVersion");
        SDKPatchingTest1.changeVersion(newCommon, newVersionCommon);
        this.newIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)newCommon));
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.equinox.common", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.equinox.common", (VersionRange)new VersionRange(newVersionCommon, true, newVersionCommon, true), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.rcp.feature.group", (VersionRange)new VersionRange("[3.5.0.v20081110-9E9vFtpFlN1yW2Ray4WRVBYE, 3.5.0.v20081110-9E9vFtpFlN1yW2Ray4WRVBYE]"), null, (boolean)false, (boolean)false, (boolean)true);
        this.patchInstallingCommon = SDKPatchingTest1.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[0][0], lifeCycle);
        this.newIUs.add(this.patchInstallingCommon);
    }

    public void testInstallFeaturePatch() {
        ProvisioningContext ctx = new ProvisioningContext(SDKPatchingTest1.getAgent());
        ctx.setExtraInstallableUnits(this.newIUs);
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.patchInstallingCommon});
        request.setInstallableUnitInclusionRules(this.patchInstallingCommon, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.patchInstallingCommon));
        IPlanner planner = SDKPatchingTest1.createPlanner();
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        SDKPatchingTest1.assertOK("Installation plan", plan.getStatus());
        SDKPatchingTest1.assertEquals((int)3, (int)this.countPlanElements(plan));
    }
}

