/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.SynchronizeOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;

public class SynchronizeOperationTest
extends AbstractProvisioningTest {
    public void testSyncOperation() throws ProvisionException {
        ServiceReference providerRef = TestActivator.context.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)TestActivator.context.getService(providerRef);
        URI p2location = SynchronizeOperationTest.getTestData("p2 location", "testData/synchronizeOperation/p2").toURI();
        URI repoLocation = SynchronizeOperationTest.getTestData("p2 location", "testData/synchronizeOperation/repo").toURI();
        IProvisioningAgent firstAgent = provider.createAgent(p2location);
        IMetadataRepositoryManager mgr = (IMetadataRepositoryManager)firstAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository repo = mgr.loadRepository(repoLocation, (IProgressMonitor)new NullProgressMonitor());
        ProvisioningSession session = new ProvisioningSession(firstAgent);
        SynchronizeOperation sync = new SynchronizeOperation(session, (Collection)repo.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet());
        Set installedIUs = ((IProfileRegistry)firstAgent.getService(IProfileRegistry.SERVICE_NAME)).getProfile("DefaultProfile").query((IQuery)new UserVisibleRootQuery(), (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
        System.out.println(installedIUs);
        sync.setProfileId("DefaultProfile");
        sync.resolveModal((IProgressMonitor)new NullProgressMonitor());
        IProvisioningPlan plan = sync.getProvisioningPlan();
        SynchronizeOperationTest.assertOK(plan.getStatus());
    }

    public void testCopyOfHelper() throws ProvisionException {
        ServiceReference providerRef = TestActivator.context.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)TestActivator.context.getService(providerRef);
        URI p2location = SynchronizeOperationTest.getTestData("p2 location", "testData/synchronizeOperation/p2").toURI();
        URI repoLocation = SynchronizeOperationTest.getTestData("p2 location", "testData/synchronizeOperation/repo").toURI();
        IProvisioningAgent firstAgent = provider.createAgent(p2location);
        VersionedId v = new VersionedId("payload.feature.feature.group", null);
        ArrayList<IVersionedId> toInstall = new ArrayList<IVersionedId>();
        toInstall.add((IVersionedId)v);
        ArrayList<URI> repos = new ArrayList<URI>();
        repos.add(repoLocation);
        SynchronizeOperation operation = this.createSynchronizeOperation(toInstall, repos, (IProgressMonitor)new NullProgressMonitor(), firstAgent);
        operation.setProfileId("DefaultProfile");
        operation.resolveModal((IProgressMonitor)new NullProgressMonitor());
        SynchronizeOperationTest.assertOK(operation.getProvisioningPlan().getStatus());
    }

    private SynchronizeOperation createSynchronizeOperation(Collection<IVersionedId> toInstall, Collection<URI> repos, IProgressMonitor monitor, IProvisioningAgent agent) throws ProvisionException {
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        Collection<Object> iusToInstall = toInstall == null ? ctx.getMetadata(monitor).query(QueryUtil.createIUGroupQuery(), monitor).toUnmodifiableSet() : this.gatherIUs((IQueryable<IInstallableUnit>)ctx.getMetadata(monitor), toInstall, false, monitor);
        SynchronizeOperation resultingOperation = new SynchronizeOperation(new ProvisioningSession(agent), (Collection)iusToInstall);
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    private ProvisioningContext createProvisioningContext(Collection<URI> repos, IProvisioningAgent agent) {
        ProvisioningContext ctx = new ProvisioningContext(agent);
        if (repos != null) {
            ctx.setMetadataRepositories(repos.toArray(new URI[repos.size()]));
            ctx.setArtifactRepositories(repos.toArray(new URI[repos.size()]));
        }
        return ctx;
    }

    private Collection<IInstallableUnit> gatherIUs(IQueryable<IInstallableUnit> searchContext, Collection<IVersionedId> ius, boolean checkIUs, IProgressMonitor monitor) throws ProvisionException {
        ArrayList<IInstallableUnit> gatheredIUs = new ArrayList<IInstallableUnit>(ius.size());
        for (IVersionedId versionedId : ius) {
            if (!checkIUs && versionedId instanceof IInstallableUnit) {
                gatheredIUs.add((IInstallableUnit)versionedId);
                continue;
            }
            IQuery installableUnits = QueryUtil.createIUQuery((String)versionedId.getId(), (Version)versionedId.getVersion());
            IQueryResult matches = searchContext.query(installableUnits, monitor);
            if (matches.isEmpty()) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.operations", NLS.bind((String)Messages.OperationFactory_noIUFound, (Object)versionedId)));
            }
            Iterator iuIt = matches.iterator();
            gatheredIUs.add((IInstallableUnit)iuIt.next());
        }
        return gatheredIUs;
    }
}

