/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerIUProperties
extends AbstractProvisioningTest {
    final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    final String INCLUSION_OPTIONAL = "OPTIONAL";
    final String INCLUSION_STRICT = "STRICT";
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit egit2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 3 \ndepends: platform = 3")
    public IInstallableUnit egit3;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private ProvisioningContext context;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1});
        this.planner = TestRequestFlexerIUProperties.createPlanner();
        this.engine = TestRequestFlexerIUProperties.createEngine();
        this.context = new ProvisioningContext(TestRequestFlexerIUProperties.getAgent());
    }

    public void testWithChanginRootFromOptionalToStrict() {
        this.profile = this.createProfile("TestProfile." + this.getName());
        TestRequestFlexerIUProperties.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.sdk1}, false, this.planner, this.engine));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2});
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit2);
        originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        originalRequest.setInstallableUnitInclusionRules(this.sdk1, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.sdk1));
        TestRequestFlexerIUProperties.assertNotOK(this.planner.getProvisioningPlan(originalRequest, null, null).getStatus());
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerIUProperties.assertEquals((int)2, (int)realRequest.getAdditions().size());
        TestRequestFlexerIUProperties.assertEquals((int)1, (int)realRequest.getRemovals().size());
    }

    public void testWithChanginRootFromOptionalToStrictByRemovingIUProperty() {
        this.profile = this.createProfile("TestProfile." + this.getName());
        TestRequestFlexerIUProperties.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.sdk1}, false, this.planner, this.engine));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2});
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit2);
        originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        originalRequest.removeInstallableUnitInclusionRules(this.sdk1);
        TestRequestFlexerIUProperties.assertNotOK(this.planner.getProvisioningPlan(originalRequest, null, null).getStatus());
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerIUProperties.assertEquals((int)2, (int)realRequest.getAdditions().size());
        TestRequestFlexerIUProperties.assertEquals((int)1, (int)realRequest.getRemovals().size());
    }

    public void testWithChanginRootFromStrictToOptional() {
        this.profile = this.createProfile("TestProfile." + this.getName());
        TestRequestFlexerIUProperties.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2});
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit2);
        originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        originalRequest.setInstallableUnitInclusionRules(this.sdk1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.sdk1));
        TestRequestFlexerIUProperties.assertOK(this.planner.getProvisioningPlan(originalRequest, null, null).getStatus());
        this.assertResolve(originalRequest, this.planner);
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerIUProperties.assertEquals((int)2, (int)realRequest.getAdditions().size());
        TestRequestFlexerIUProperties.assertEquals((int)1, (int)realRequest.getRemovals().size());
        this.assertResolve(realRequest, this.planner);
        TestRequestFlexerIUProperties.assertTrue((boolean)this.isOptionallyBeingInstalled(this.sdk2, realRequest));
    }

    public void testRandomIUProperty() {
        this.profile = this.createProfile("TestProfile." + this.getName());
        TestRequestFlexerIUProperties.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2});
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit3);
        originalRequest.setInstallableUnitInclusionRules(this.egit3, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit3));
        originalRequest.setInstallableUnitProfileProperty(this.egit3, "MYKEY", "MYVALUE");
        TestRequestFlexerIUProperties.assertNotOK(this.planner.getProvisioningPlan(originalRequest, null, null).getStatus());
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowDifferentVersion(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerIUProperties.assertTrue((boolean)realRequest.getAdditions().contains(this.egit1));
        TestRequestFlexerIUProperties.assertEquals((int)1, (int)realRequest.getAdditions().size());
        this.assertResolve(realRequest, this.planner);
        this.assertKeyValue(this.egit1, "MYKEY", "MYVALUE", realRequest);
    }

    private void assertKeyValue(IInstallableUnit iu, String key, String value, IProfileChangeRequest request) {
        Map match = (Map)((ProfileChangeRequest)request).getInstallableUnitProfilePropertiesToAdd().get(iu);
        TestRequestFlexerIUProperties.assertNotNull((Object)match);
        TestRequestFlexerIUProperties.assertEquals((String)value, (String)((String)match.get(key)));
    }

    private boolean isOptionallyBeingInstalled(IInstallableUnit iu, IProfileChangeRequest request) {
        Map match = (Map)((ProfileChangeRequest)request).getInstallableUnitProfilePropertiesToAdd().get(iu);
        if (match == null) {
            return false;
        }
        return "OPTIONAL".equals(match.get("org.eclipse.equinox.p2.internal.inclusion.rules"));
    }
}

