/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerProduct2
extends AbstractProvisioningTest {
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: eppPackage \nsingleton: true\nversion: 1 \ndepends: SDK = 1")
    public IInstallableUnit eppPackage1;
    @IUDescription(content="package: eppPackage \nsingleton: true\nversion: 2 \ndepends: SDK = 2")
    public IInstallableUnit eppPackage2;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private ProvisioningContext context;

    private void setupSDK1() {
        IRequirement[] reqPlatform1 = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"platform", (VersionRange)new VersionRange("[1.0.0,1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)};
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("org.eclipse.equinox.p2.type.product", Boolean.TRUE.toString());
        this.sdk1 = TestRequestFlexerProduct2.createIU("SDK", Version.create((String)"1.0.0"), null, reqPlatform1, new IProvidedCapability[0], p, null, null, true);
    }

    private void setupSDK2() {
        IRequirement[] reqPlatform1 = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"platform", (VersionRange)new VersionRange("[2.0.0,2.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)};
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("org.eclipse.equinox.p2.type.product", Boolean.TRUE.toString());
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)"SDK", (VersionRange)new VersionRange("[1.0.0,2.0.0)"), (int)0, (String)"description");
        this.sdk2 = TestRequestFlexerProduct2.createIU("SDK", Version.create((String)"2.0.0"), null, reqPlatform1, new IProvidedCapability[0], p, null, null, true, update, null);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context = new ProvisioningContext(TestRequestFlexerProduct2.getAgent());
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.setupSDK1();
        this.setupSDK2();
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.eppPackage1, this.eppPackage2});
        this.planner = TestRequestFlexerProduct2.createPlanner();
        this.engine = TestRequestFlexerProduct2.createEngine();
        TestRequestFlexerProduct2.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.eppPackage1}, true, this.planner, this.engine));
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.getProfileRegistry().removeProfile(this.profile.getProfileId());
    }

    public void testReplaceNonRootProduct() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(false);
        av.setAllowDifferentVersion(false);
        av.setAllowInstalledElementRemoval(true);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest specialRequest = this.planner.createChangeRequest(this.profile);
        specialRequest.add(this.eppPackage2);
        specialRequest.setInstallableUnitInclusionRules(this.eppPackage2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.eppPackage2));
        IProfileChangeRequest realRequest = av.getChangeRequest(specialRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerProduct2.assertTrue((boolean)realRequest.getAdditions().contains(this.eppPackage2));
        TestRequestFlexerProduct2.assertFalse((boolean)this.getPlanner(TestRequestFlexerProduct2.getAgent()).getProvisioningPlan(realRequest, this.context, (IProgressMonitor)new NullProgressMonitor()).getAdditions().query(QueryUtil.createIUQuery((String)"SDK", (Version)Version.create((String)"2.0.0")), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
    }
}

