/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.planner.Bug207319;

public class UninstallEverything
extends AbstractProvisioningTest {
    IInstallableUnit a;
    IDirector director;
    IProfile profile;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = UninstallEverything.createIU("A", Version.create((String)"1.0.0"));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a});
        this.profile = this.createProfile(Bug207319.class.getName());
        this.director = UninstallEverything.createDirector();
    }

    public void testEmpty() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a});
        UninstallEverything.assertEquals((int)0, (int)this.director.provision((IProfileChangeRequest)req, null, null).getSeverity());
        UninstallEverything.assertProfileContainsAll("A is missing", this.profile, new IInstallableUnit[]{this.a});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile);
        req2.removeInstallableUnits(new IInstallableUnit[]{this.a});
        UninstallEverything.assertEquals((int)0, (int)this.director.provision((IProfileChangeRequest)req2, null, null).getSeverity());
        UninstallEverything.assertNotIUs(new IInstallableUnit[]{this.a}, this.profile.query(QueryUtil.createIUAnyQuery(), null).iterator());
    }
}

