/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class UpdateQueryTest
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit updateOfA;
    private IInstallableUnit a11;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = UpdateQueryTest.createIU("A", Version.create((String)"2.0.0"));
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)new VersionRange("[2.0.0, 2.0.0]"), (int)0, (String)"update description");
        this.updateOfA = UpdateQueryTest.createIU("UpdateA", Version.createOSGi((int)1, (int)0, (int)0), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, null, NO_TP_DATA, false, update, (IRequirement[])NO_REQUIRES);
        this.a11 = this.createIUUpdate();
    }

    public void testUpdateWithDifferentId() {
        IMetadataRepository repo = this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.updateOfA});
        IQueryResult c = repo.query((IQuery)new UpdateQuery(this.a1), null);
        UpdateQueryTest.assertEquals((int)1, (int)UpdateQueryTest.queryResultSize(c));
        UpdateQueryTest.assertEquals((Object)this.updateOfA, c.iterator().next());
    }

    public void testWithSuperiorVersion() {
        IMetadataRepository repo2 = this.createTestMetdataRepository(new IInstallableUnit[]{this.a11, this.a1});
        IQueryResult c2 = repo2.query((IQuery)new UpdateQuery(this.a1), null);
        UpdateQueryTest.assertEquals((int)1, (int)UpdateQueryTest.queryResultSize(c2));
        UpdateQueryTest.assertEquals((Object)this.a11, c2.iterator().next());
    }

    private IInstallableUnit createIUUpdate() {
        return UpdateQueryTest.createIU("A", Version.create((String)"2.1.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)new VersionRange("[2.0.0, 2.1.0]"), (int)0, (String)"update description"), null);
    }
}

