/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public final class AbstractPublisherActionTest
extends AbstractProvisioningTest {
    public void testAddUpdateDescriptor() {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("test");
        PublisherInfo info = new PublisherInfo();
        VersionRange range = new VersionRange("[0.0.0,1.1.1)");
        IUpdateDescriptor testUpdateDescriptor = MetadataFactory.createUpdateDescriptor((String)"name1", (VersionRange)range, (int)10, (String)"Test Description");
        info.addAdvice((IPublisherAdvice)new TestUpdateDescriptorAdvice(testUpdateDescriptor));
        TestAction action = new TestAction();
        action.testProcessUpdateDescriptorAdvice(iu, (IPublisherInfo)info);
        AbstractPublisherActionTest.assertEquals((String)"name1", (String)RequiredCapability.extractName((IMatchExpression)((IMatchExpression)iu.getUpdateDescriptor().getIUsBeingUpdated().iterator().next())));
        AbstractPublisherActionTest.assertEquals((Object)range, (Object)RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)iu.getUpdateDescriptor().getIUsBeingUpdated().iterator().next())));
        AbstractPublisherActionTest.assertEquals((int)10, (int)iu.getUpdateDescriptor().getSeverity());
        AbstractPublisherActionTest.assertEquals((String)"Test Description", (String)iu.getUpdateDescriptor().getDescription());
    }

    public void testAddCapabilities() {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("test");
        AbstractPublisherActionTest.assertEquals((int)0, (int)iu.getRequirements().size());
        AbstractPublisherActionTest.assertEquals((int)0, (int)iu.getProvidedCapabilities().size());
        AbstractPublisherActionTest.assertEquals((int)0, (int)iu.getMetaRequirements().size());
        PublisherInfo info = new PublisherInfo();
        IRequirement testRequiredCapability = MetadataFactory.createRequirement((String)"ns1", (String)"name1", null, null, (boolean)false, (boolean)false, (boolean)false);
        IProvidedCapability testProvideCapability = MetadataFactory.createProvidedCapability((String)"ns2", (String)"name2", (Version)Version.createOSGi((int)9, (int)0, (int)0));
        IRequirement testMetaRequiredCapability = MetadataFactory.createRequirement((String)"ns3", (String)"name3", null, null, (boolean)false, (boolean)false, (boolean)false);
        info.addAdvice((IPublisherAdvice)new TestCapabilityAdvice(testProvideCapability, testRequiredCapability, testMetaRequiredCapability));
        TestAction action = new TestAction();
        action.testProcessCapabilityAdvice(iu, (IPublisherInfo)info);
        AbstractPublisherActionTest.assertEquals((String)"name1", (String)((IRequiredCapability)iu.getRequirements().iterator().next()).getName());
        AbstractPublisherActionTest.assertEquals((String)"name2", (String)((IProvidedCapability)iu.getProvidedCapabilities().iterator().next()).getName());
        AbstractPublisherActionTest.assertEquals((String)"name3", (String)((IRequiredCapability)iu.getMetaRequirements().iterator().next()).getName());
    }

    public void testAddCapabilitiesIdentityCounts() {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("test");
        IRequirement[] requiredCapabilities = new IRequirement[]{MetadataFactory.createRequirement((String)"rtest1", (String)"test1", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest1", (String)"test1", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest2", (String)"test2", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest2", (String)"test2", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest3", (String)"test3", null, null, (boolean)false, (boolean)false, (boolean)false)};
        iu.setRequirements(requiredCapabilities);
        IProvidedCapability[] providedCapabilities = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"ptest1", (String)"test1", (Version)Version.createOSGi((int)1, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest1", (String)"test1", (Version)Version.createOSGi((int)2, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest2", (String)"test2", (Version)Version.createOSGi((int)1, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest2", (String)"test2", (Version)Version.createOSGi((int)2, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest3", (String)"test3", null)};
        iu.setCapabilities(providedCapabilities);
        IRequirement[] metaRequiredCapabilities = new IRequirement[]{MetadataFactory.createRequirement((String)"mtest1", (String)"test1", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest1", (String)"test1", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest2", (String)"test2", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest2", (String)"test2", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest3", (String)"test3", null, null, (boolean)false, (boolean)false, (boolean)false)};
        iu.setMetaRequirements(metaRequiredCapabilities);
        AbstractPublisherActionTest.assertEquals((int)5, (int)iu.getRequirements().size());
        AbstractPublisherActionTest.assertEquals((int)5, (int)iu.getProvidedCapabilities().size());
        AbstractPublisherActionTest.assertEquals((int)5, (int)iu.getMetaRequirements().size());
        PublisherInfo info = new PublisherInfo();
        IRequirement testRequiredCapability = MetadataFactory.createRequirement((String)"ns1", (String)"name1", null, null, (boolean)false, (boolean)false, (boolean)false);
        IProvidedCapability testProvideCapability = MetadataFactory.createProvidedCapability((String)"ns2", (String)"name2", (Version)Version.createOSGi((int)9, (int)0, (int)0));
        IRequirement testMetaRequiredCapability = MetadataFactory.createRequirement((String)"ns3", (String)"name3", null, null, (boolean)false, (boolean)false, (boolean)false);
        info.addAdvice((IPublisherAdvice)new TestCapabilityAdvice(testProvideCapability, testRequiredCapability, testMetaRequiredCapability));
        TestAction action = new TestAction();
        action.testProcessCapabilityAdvice(iu, (IPublisherInfo)info);
        AbstractPublisherActionTest.assertEquals((int)6, (int)iu.getRequirements().size());
        AbstractPublisherActionTest.assertEquals((int)6, (int)iu.getProvidedCapabilities().size());
        AbstractPublisherActionTest.assertEquals((int)6, (int)iu.getMetaRequirements().size());
    }

    public void testReplaceCapabilities() {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("test");
        iu.setRequirements(AbstractPublisherActionTest.createRequiredCapabilities("ns1", "name1", null, ""));
        iu.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"ns2", (String)"name2", null)});
        iu.setMetaRequirements(AbstractPublisherActionTest.createRequiredCapabilities("ns3", "name3", null, ""));
        AbstractPublisherActionTest.assertNotSame((Object)9, (Object)PublisherHelper.toOSGiVersion((Version)((IProvidedCapability)iu.getProvidedCapabilities().iterator().next()).getVersion()).getMajor());
        AbstractPublisherActionTest.assertTrue((boolean)((IRequirement)iu.getRequirements().iterator().next()).isGreedy());
        AbstractPublisherActionTest.assertTrue((boolean)((IRequirement)iu.getMetaRequirements().iterator().next()).isGreedy());
        PublisherInfo info = new PublisherInfo();
        IRequirement testRequiredCapability = MetadataFactory.createRequirement((String)"ns1", (String)"name1", null, null, (boolean)false, (boolean)false, (boolean)false);
        IProvidedCapability testProvideCapability = MetadataFactory.createProvidedCapability((String)"ns2", (String)"name2", (Version)Version.createOSGi((int)9, (int)0, (int)0));
        IRequirement testMetaRequiredCapability = MetadataFactory.createRequirement((String)"ns3", (String)"name3", null, null, (boolean)false, (boolean)false, (boolean)false);
        info.addAdvice((IPublisherAdvice)new TestCapabilityAdvice(testProvideCapability, testRequiredCapability, testMetaRequiredCapability));
        TestAction action = new TestAction();
        action.testProcessCapabilityAdvice(iu, (IPublisherInfo)info);
        AbstractPublisherActionTest.assertEquals((int)9, (int)PublisherHelper.toOSGiVersion((Version)((IProvidedCapability)iu.getProvidedCapabilities().iterator().next()).getVersion()).getMajor());
        AbstractPublisherActionTest.assertFalse((boolean)((IRequirement)iu.getRequirements().iterator().next()).isGreedy());
        AbstractPublisherActionTest.assertFalse((boolean)((IRequirement)iu.getMetaRequirements().iterator().next()).isGreedy());
    }

    public void testReplaceCapabilitiesIdentityCounts() {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("test");
        IRequirement[] requiredCapabilities = new IRequirement[]{MetadataFactory.createRequirement((String)"rtest1", (String)"test1", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest1", (String)"test1", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest2", (String)"test2", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest2", (String)"test2", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"rtest3", (String)"test3", null, null, (boolean)false, (boolean)false, (boolean)false)};
        iu.setRequirements(requiredCapabilities);
        IProvidedCapability[] providedCapabilities = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"ptest1", (String)"test1", (Version)Version.createOSGi((int)1, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest1", (String)"test1", (Version)Version.createOSGi((int)2, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest2", (String)"test2", (Version)Version.createOSGi((int)1, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest2", (String)"test2", (Version)Version.createOSGi((int)2, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"ptest3", (String)"test3", null)};
        iu.setCapabilities(providedCapabilities);
        IRequirement[] metaRequiredCapabilities = new IRequirement[]{MetadataFactory.createRequirement((String)"mtest1", (String)"test1", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest1", (String)"test1", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest2", (String)"test2", (VersionRange)new VersionRange("[1,2)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest2", (String)"test2", (VersionRange)new VersionRange("[2,3)"), null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"mtest3", (String)"test3", null, null, (boolean)false, (boolean)false, (boolean)false)};
        iu.setMetaRequirements(metaRequiredCapabilities);
        AbstractPublisherActionTest.assertEquals((int)5, (int)iu.getRequirements().size());
        AbstractPublisherActionTest.assertEquals((int)5, (int)iu.getProvidedCapabilities().size());
        AbstractPublisherActionTest.assertEquals((int)5, (int)iu.getMetaRequirements().size());
        PublisherInfo info = new PublisherInfo();
        IRequirement testRequiredCapability = MetadataFactory.createRequirement((String)"rtest1", (String)"test1", null, null, (boolean)false, (boolean)false, (boolean)false);
        IProvidedCapability testProvideCapability = MetadataFactory.createProvidedCapability((String)"ptest1", (String)"test1", null);
        IRequirement testMetaRequiredCapability = MetadataFactory.createRequirement((String)"mtest1", (String)"test1", null, null, (boolean)false, (boolean)false, (boolean)false);
        info.addAdvice((IPublisherAdvice)new TestCapabilityAdvice(testProvideCapability, testRequiredCapability, testMetaRequiredCapability));
        TestAction action = new TestAction();
        action.testProcessCapabilityAdvice(iu, (IPublisherInfo)info);
        AbstractPublisherActionTest.assertEquals((int)4, (int)iu.getRequirements().size());
        AbstractPublisherActionTest.assertEquals((int)4, (int)iu.getProvidedCapabilities().size());
        AbstractPublisherActionTest.assertEquals((int)4, (int)iu.getMetaRequirements().size());
    }

    static class TestAction
    extends AbstractPublisherAction {
        TestAction() {
        }

        public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
            return null;
        }

        public void testProcessCapabilityAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo publisherInfo) {
            AbstractPublisherAction.processCapabilityAdvice((MetadataFactory.InstallableUnitDescription)iu, (IPublisherInfo)publisherInfo);
        }

        public void testProcessUpdateDescriptorAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo publisherInfo) {
            AbstractPublisherAction.processUpdateDescriptorAdvice((MetadataFactory.InstallableUnitDescription)iu, (IPublisherInfo)publisherInfo);
        }
    }

    static class TestCapabilityAdvice
    implements ICapabilityAdvice {
        private final IProvidedCapability providedCapability;
        private final IRequirement requiredCapability;
        private final IRequirement metaRequiredCapability;

        public TestCapabilityAdvice(IProvidedCapability providedCapability, IRequirement requiredCapability, IRequirement metaRequiredCapability) {
            this.providedCapability = providedCapability;
            this.requiredCapability = requiredCapability;
            this.metaRequiredCapability = metaRequiredCapability;
        }

        public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
            if (this.providedCapability == null) {
                return null;
            }
            return new IProvidedCapability[]{this.providedCapability};
        }

        public IRequirement[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
            if (this.requiredCapability == null) {
                return null;
            }
            return new IRequirement[]{this.requiredCapability};
        }

        public IRequirement[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
            if (this.metaRequiredCapability == null) {
                return null;
            }
            return new IRequirement[]{this.metaRequiredCapability};
        }

        public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
            return id.equals("test");
        }
    }

    static class TestUpdateDescriptorAdvice
    implements IUpdateDescriptorAdvice {
        private final IUpdateDescriptor updateDescriptor;

        public TestUpdateDescriptorAdvice(IUpdateDescriptor updateDescriptor) {
            this.updateDescriptor = updateDescriptor;
        }

        public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
            return id.equals("test");
        }

        public IUpdateDescriptor getUpdateDescriptor(MetadataFactory.InstallableUnitDescription iu) {
            return this.updateDescriptor;
        }
    }
}

