/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public abstract class ActionTest
extends AbstractProvisioningTest {
    protected static final String COMMA_SEPARATOR = ",";
    protected static final String JAR = "jar";
    private static final boolean DEBUG = false;
    protected String os = "win32";
    protected String ws = "win32";
    protected String arch = "x86";
    protected String configSpec = AbstractPublisherAction.createConfigSpec((String)this.ws, (String)this.os, (String)this.arch);
    protected String flavorArg = "tooling";
    protected String[] topLevel;
    protected AbstractPublisherAction testAction;
    protected IPublisherInfo publisherInfo;
    protected IPublisherResult publisherResult;

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void verifyProvidedCapability(Collection<IProvidedCapability> prov, String namespace, String name, Version version) {
        for (IProvidedCapability pc : prov) {
            if (!pc.getName().equalsIgnoreCase(name) || !pc.getNamespace().equalsIgnoreCase(namespace) || !pc.getVersion().equals(version)) continue;
            return;
        }
        Assert.fail((String)("Missing ProvidedCapability: " + name + version.toString()));
    }

    protected void verifyRequirement(Collection<IRequirement> actual, String namespace, String name, VersionRange range) {
        this.verifyRequirement(actual, namespace, name, range, null, 1, 1, true);
    }

    protected void verifyRequirement(Collection<IRequirement> actual, String namespace, String name, VersionRange range, String envFilter, int minCard, int maxCard, boolean greedy) {
        IRequirement expected = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)envFilter), (int)minCard, (int)maxCard, (boolean)greedy);
        this.verifyRequirement(actual, expected);
    }

    protected void verifyRequirement(Collection<IRequirement> actual, String namespace, String propsFilter, String envFilter, int minCard, int maxCard, boolean greedy) {
        IRequirement expected = MetadataFactory.createRequirement((String)namespace, (String)propsFilter, (IMatchExpression)InstallableUnit.parseFilter((String)envFilter), (int)minCard, (int)maxCard, (boolean)greedy);
        this.verifyRequirement(actual, expected);
    }

    protected void verifyRequirement(Collection<IRequirement> actual, IRequirement expected) {
        for (IRequirement act : actual) {
            if (!expected.getMatches().equals(act.getMatches())) continue;
            String descr = "IRequirement " + expected.getMatches();
            Assert.assertEquals((String)("Min of " + descr), (long)expected.getMin(), (long)act.getMin());
            Assert.assertEquals((String)("Max of " + descr), (long)expected.getMax(), (long)act.getMax());
            Assert.assertEquals((String)("Greedy of " + descr), (Object)expected.isGreedy(), (Object)act.isGreedy());
            return;
        }
        Assert.fail((String)("Missing IRequirement: " + expected));
    }

    protected IInstallableUnit mockIU(String id, Version version) {
        IInstallableUnit result = (IInstallableUnit)EasyMock.createMock(IInstallableUnit.class);
        EasyMock.expect((Object)result.getId()).andReturn((Object)id).anyTimes();
        if (version == null) {
            version = Version.emptyVersion;
        }
        EasyMock.expect((Object)result.getVersion()).andReturn((Object)version).anyTimes();
        EasyMock.expect((Object)result.getFilter()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    protected Map<String, Object[]> getFileMap(Map<String, Object[]> map, File[] files, Path root) {
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                map = this.getFileMap(map, files[i].listFiles(), root);
            } else if (!files[i].getPath().endsWith(JAR)) {
                try {
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    File contentBytes = files[i];
                    FileUtils.copyStream((InputStream)new FileInputStream(contentBytes), (boolean)false, (OutputStream)content, (boolean)true);
                    Path entryPath = new Path(files[i].getAbsolutePath());
                    entryPath = entryPath.removeFirstSegments(root.matchingFirstSegments((IPath)entryPath));
                    entryPath = entryPath.setDevice(null);
                    map.put(entryPath.toString(), new Object[]{contentBytes, content.toByteArray()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return map;
    }

    public void setupPublisherResult() {
        this.publisherResult = new PublisherResult();
    }

    public void setupPublisherInfo() {
        this.publisherInfo = this.createPublisherInfoMock();
        String[] config = ActionTest.getArrayFromString(this.configSpec, COMMA_SEPARATOR);
        EasyMock.expect((Object)this.publisherInfo.getConfigurations()).andReturn((Object)config).anyTimes();
        this.insertPublisherInfoBehavior();
        EasyMock.replay((Object[])new Object[]{this.publisherInfo});
    }

    protected IPublisherInfo createPublisherInfoMock() {
        return (IPublisherInfo)EasyMock.createMock(IPublisherInfo.class);
    }

    protected void insertPublisherInfoBehavior() {
        EasyMock.expect((Object)this.publisherInfo.getMetadataRepository()).andReturn((Object)this.createTestMetdataRepository(new IInstallableUnit[0])).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getContextMetadataRepository()).andReturn((Object)this.createTestMetdataRepository(new IInstallableUnit[0])).anyTimes();
    }

    public void cleanup() {
        this.publisherInfo = null;
        this.publisherResult = null;
    }

    public void debug(String message) {
    }

    protected final void addContextIU(String unitId, String unitVersion) {
        this.publisherResult.addIU(ActionTest.createIU(unitId, Version.create((String)unitVersion)), "non_root");
    }

    protected final void addContextIU(String unitId, String unitVersion, String filter) {
        this.publisherResult.addIU(ActionTest.createIU(unitId, Version.create((String)unitVersion), filter, NO_PROVIDES), "non_root");
    }

    protected final IInstallableUnit getUniquePublishedIU(String id) {
        Assert.assertThat((Object)this.publisherResult, ActionTest.containsUniqueIU(id));
        IQueryResult queryResult = this.publisherResult.query(QueryUtil.createIUQuery((String)id), (IProgressMonitor)new NullProgressMonitor());
        return (IInstallableUnit)queryResult.iterator().next();
    }

    public static Matcher<IPublisherResult> containsIU(final String id) {
        final IQuery query = QueryUtil.createIUQuery((String)id);
        return new TypeSafeMatcher<IPublisherResult>(){

            public void describeTo(Description description) {
                description.appendText("contains a unit " + id);
            }

            public boolean matchesSafely(IPublisherResult item) {
                IQueryResult queryResult = item.query(query, null);
                return ActionTest.queryResultSize(queryResult) > 0;
            }
        };
    }

    public static Matcher<IPublisherResult> containsUniqueIU(final String id) {
        final IQuery query = QueryUtil.createIUQuery((String)id);
        return new TypeSafeMatcher<IPublisherResult>(){

            public void describeTo(Description description) {
                description.appendText("contains exactly one unit " + id);
            }

            public boolean matchesSafely(IPublisherResult item) {
                IQueryResult queryResult = item.query(query, null);
                return ActionTest.queryResultSize(queryResult) == 1;
            }
        };
    }
}

