/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.AdviceMatcher;
import org.eclipse.equinox.p2.tests.publisher.actions.MultiCapture;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class BundlesActionTest
extends ActionTest {
    private static final String OSGI = "osgi.bundle";
    private static final String OSGI_IDENTITY = "osgi.identity";
    private static final String OSGI_EE = "osgi.ee";
    private static final String JAVA_PACKAGE = "java.package";
    private static final String JAVA_EE_1_4 = "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))";
    private static final String JAVA_EE_1_6 = "(&(osgi.ee=JavaSE)(version=1.6))";
    private static final String TEST1_IUD_NAME = "iud";
    private static final String TEST1_PROVZ_NAME = "iuz";
    private static final String TEST1_PROVBUNDLE_NAME = "test1";
    private static final String TEST1_REQ_EE = "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))";
    private static final String TEST2_REQ_A_NAME = "iua";
    private static final String TEST2_REQ_B_NAME = "iub";
    private static final String TEST2_REQ_C_NAME = "iuc";
    private static final String TEST2_REQ_EE = "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))";
    private static final String TEST2_PROV_Z_NAME = "iuz";
    private static final String TEST2_PROV_Y_NAME = "iuy";
    private static final String TEST2_PROV_X_NAME = "iux";
    private static final String TEST2_PROV_BUNDLE_NAME = "test2";
    private static final String TEST3_PROV_BUNDLE_NAME = "test3";
    private static final String TEST4_PROV_BUNDLE_NAME = "test4";
    private static final String TEST4_REQ_PACKAGE_OPTIONAL_NAME = "iue";
    private static final String TEST4_REQ_PACKAGE_OPTGREEDY_NAME = "iuf";
    private static final String TEST4_REQ_BUNDLE_OPTIONAL_NAME = "iug";
    private static final String TEST4_REQ_BUNDLE_OPTGREEDY_NAME = "iuh";
    private static final String TEST5_REQ_EE = "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))";
    private static final String TEST5_PROV_BUNDLE_NAME = "test5";
    private static final String TESTDYN_REQ_EE = "(&(osgi.ee=JavaSE)(version=1.6))";
    private static final File TEST_BASE = new File(TestActivator.getTestDataFolder(), "BundlesActionTest");
    private static final File TEST_FILE1 = new File(TEST_BASE, "test1");
    private static final File TEST_FILE2 = new File(TEST_BASE, "test2.jar");
    private static final File TEST_FILE2_PACKED = new File(TEST_BASE, "test2.jar.pack.gz");
    private static final String PROVBUNDLE_NAMESPACE = "org.eclipse.equinox.p2.iu";
    private static final String TEST2_IU_A_NAMESPACE = "osgi.bundle";
    private static final String TEST2_IU_B_NAMESPACE = "java.package";
    private static final String TEST2_IU_C_NAMESPACE = "java.package";
    private static final String TEST1_IU_D_NAMESPACE = "java.package";
    private static final String TEST2_PROV_Z_NAMESPACE = "java.package";
    private static final String TEST2_PROV_Y_NAMESPACE = "java.package";
    private static final String TEST2_PROV_X_NAMESPACE = "java.package";
    private static final String TEST1_PROV_Z_NAMESPACE = "java.package";
    private static final Version BUNDLE1_VERSION = Version.create((String)"0.1.0");
    private static final Version BUNDLE2_VERSION = Version.create((String)"1.0.0.qualifier");
    private static final Version BUNDLE3_VERSION = Version.create((String)"0.1.0.qualifier");
    private static final Version BUNDLE4_VERSION = Version.create((String)"2.0.1");
    private static final Version BUNDLE5_VERSION = Version.create((String)"0.1.0.qualifier");
    private static final VersionRange DEFAULT_VERSION_RANGE = VersionRange.emptyRange;
    private static final Version PROVBUNDLE2_VERSION = BUNDLE2_VERSION;
    private static final Version TEST2_PROVZ_VERSION = Version.emptyVersion;
    private static final Version TEST2_PROVY_VERSION = Version.emptyVersion;
    private static final Version TEST2_PROVX_VERSION = Version.emptyVersion;
    private static final VersionRange TEST2_IU_A_VERSION_RANGE = VersionRange.emptyRange;
    private static final VersionRange TEST2_IU_B_VERSION_RANGE = VersionRange.emptyRange;
    private static final VersionRange TEST2_IU_C_VERSION_RANGE = VersionRange.create((String)"1.0.0");
    private static final VersionRange TEST1_IU_D_VERSION_RANGE = VersionRange.create((String)"1.3.0");
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(BundlesActionTest.getAgent());
    private MultiCapture<ITouchpointAdvice> tpAdvice1;
    private MultiCapture<ITouchpointAdvice> tpAdvice2;
    private MultiCapture<IUpdateDescriptorAdvice> udAdvice3;
    private MultiCapture<ICapabilityAdvice> capAdvice5;

    @Override
    public void setupPublisherInfo() {
        this.tpAdvice1 = new MultiCapture();
        this.tpAdvice2 = new MultiCapture();
        this.udAdvice3 = new MultiCapture();
        this.capAdvice5 = new MultiCapture();
        super.setupPublisherInfo();
    }

    public void testAll() throws Exception {
        File[] files = TEST_BASE.listFiles();
        this.testAction = new BundlesAction(files);
        this.setupPublisherResult();
        this.setupPublisherInfo();
        this.artifactRepository.setProperty("publishPackFilesAsSiblings", "true");
        BundlesActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
        this.verifyBundlesAction();
        this.cleanup();
        this.debug("Completed BundlesActionTest.");
    }

    public void testTranslationFragment() {
        File foo_fragment = new File(TestActivator.getTestDataFolder(), "FragmentPublisherTest/foo.fragment");
        File foo = new File(TestActivator.getTestDataFolder(), "FragmentPublisherTest/foo");
        BundlesAction bundlesAction = new BundlesAction(new File[]{foo_fragment});
        PublisherInfo info = new PublisherInfo();
        PublisherResult results = new PublisherResult();
        bundlesAction.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        Collection ius = results.getIUs(null, null);
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        info = new PublisherInfo();
        results = new PublisherResult();
        bundlesAction = new BundlesAction(new File[]{foo});
        bundlesAction.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        ius = results.getIUs(null, null);
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        QueryableArray queryableArray = new QueryableArray(ius.toArray(new IInstallableUnit[ius.size()]));
        IQueryResult result = queryableArray.query(QueryUtil.createIUQuery((String)"foo"), null);
        BundlesActionTest.assertEquals((int)1, (int)BundlesActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        TranslationSupport utils = new TranslationSupport();
        utils.setTranslationSource((IQueryable)queryableArray);
        BundlesActionTest.assertEquals((String)"English Foo", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name"));
        bundlesAction = new BundlesAction(new File[]{foo_fragment});
        bundlesAction.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        ius = results.getIUs(null, null);
        BundlesActionTest.assertEquals((int)3, (int)ius.size());
        queryableArray = new QueryableArray(ius.toArray(new IInstallableUnit[ius.size()]));
        result = queryableArray.query(QueryUtil.createIUQuery((String)"foo"), null);
        BundlesActionTest.assertEquals((int)1, (int)BundlesActionTest.queryResultSize(result));
        iu = (IInstallableUnit)result.iterator().next();
        utils.setTranslationSource((IQueryable)queryableArray);
        BundlesActionTest.assertEquals((String)"German Foo", (String)utils.getIUProperty(iu, "org.eclipse.equinox.p2.name", Locale.GERMAN.toString()));
    }

    private void verifyBundlesAction() throws Exception {
        this.verifyBundle1();
        this.verifyBundle2();
        this.verifyBundle3();
        this.verifyBundle4();
        this.verifyBundle5();
        this.verifyArtifactRepository();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyArtifactRepository() throws Exception {
        int packedIdx;
        IArtifactDescriptor[] descriptors;
        block15: {
            int canonicalIdx;
            IArtifactKey key2 = ArtifactKey.parse((String)"osgi.bundle,test2,1.0.0.qualifier");
            descriptors = this.artifactRepository.getArtifactDescriptors(key2);
            BundlesActionTest.assertEquals((int)2, (int)descriptors.length);
            if ("packed".equals(descriptors[0].getProperty("format"))) {
                packedIdx = 0;
                canonicalIdx = 1;
            } else {
                packedIdx = 1;
                canonicalIdx = 0;
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                ZipInputStream actual = this.artifactRepository.getZipInputStream(descriptors[canonicalIdx]);
                try {
                    try (ZipInputStream expected = new ZipInputStream(new FileInputStream(TEST_FILE2));){
                        TestData.assertEquals(expected, actual);
                    }
                    if (actual == null) break block15;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (actual == null) throw throwable;
                    actual.close();
                    throw throwable;
                }
                actual.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        InputStream packedActual = this.artifactRepository.getRawInputStream(descriptors[packedIdx]);
        BufferedInputStream packedExpected = new BufferedInputStream(new FileInputStream(TEST_FILE2_PACKED));
        TestData.assertEquals(packedExpected, packedActual);
        IArtifactKey key1 = ArtifactKey.parse((String)"osgi.bundle,test1,0.1.0");
        ZipInputStream zis = this.artifactRepository.getZipInputStream(key1);
        Map<String, Object[]> fileMap = this.getFileMap(new HashMap<String, Object[]>(), new File[]{TEST_FILE1}, new Path(TEST_FILE1.getAbsolutePath()));
        TestData.assertContains(fileMap, zis, true);
    }

    private void verifyBundle1() {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(TEST1_PROVBUNDLE_NAME, "root"));
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit bundle1IU = (IInstallableUnit)ius.get(0);
        BundlesActionTest.assertNotNull((Object)bundle1IU);
        BundlesActionTest.assertEquals((Object)bundle1IU.getVersion(), (Object)BUNDLE1_VERSION);
        Collection requirements = bundle1IU.getRequirements();
        this.verifyRequirement(requirements, "java.package", TEST1_IUD_NAME, TEST1_IU_D_VERSION_RANGE);
        this.verifyRequirement(requirements, OSGI_EE, "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))", null, 1, 1, true);
        BundlesActionTest.assertEquals((int)2, (int)requirements.size());
        Collection providedCapabilities = bundle1IU.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapabilities, PROVBUNDLE_NAMESPACE, TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION);
        this.verifyProvidedCapability(providedCapabilities, OSGI_IDENTITY, TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "osgi.bundle", TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "java.package", "iuz", TEST2_PROVZ_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.eclipse.type", "source", Version.create((String)"1.0.0"));
        BundlesActionTest.assertEquals((int)5, (int)providedCapabilities.size());
        Collection data = bundle1IU.getTouchpointData();
        boolean found = false;
        for (ITouchpointData td : data) {
            String body;
            ITouchpointInstruction configure = td.getInstruction("configure");
            if (configure == null || (body = configure.getBody()) == null || body.indexOf("download.eclipse.org/releases/ganymede") <= 0) continue;
            found = true;
        }
        BundlesActionTest.assertTrue((boolean)found);
    }

    private void verifyBundle2() {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(TEST2_PROV_BUNDLE_NAME, "root"));
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit bundleIu = (IInstallableUnit)ius.get(0);
        BundlesActionTest.assertNotNull((Object)bundleIu);
        BundlesActionTest.assertEquals((Object)bundleIu.getVersion(), (Object)BUNDLE2_VERSION);
        Collection requirements = bundleIu.getRequirements();
        this.verifyRequirement(requirements, "osgi.bundle", TEST2_REQ_A_NAME, TEST2_IU_A_VERSION_RANGE);
        this.verifyRequirement(requirements, "java.package", TEST2_REQ_B_NAME, TEST2_IU_B_VERSION_RANGE);
        this.verifyRequirement(requirements, "java.package", TEST2_REQ_C_NAME, TEST2_IU_C_VERSION_RANGE);
        this.verifyRequirement(requirements, OSGI_EE, "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))", null, 1, 1, true);
        BundlesActionTest.assertEquals((int)4, (int)requirements.size());
        Collection providedCapabilities = bundleIu.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapabilities, PROVBUNDLE_NAMESPACE, TEST2_PROV_BUNDLE_NAME, PROVBUNDLE2_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "osgi.bundle", TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION);
        this.verifyProvidedCapability(providedCapabilities, OSGI_IDENTITY, TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "java.package", "iuz", TEST2_PROVZ_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "java.package", TEST2_PROV_Y_NAME, TEST2_PROVY_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "java.package", TEST2_PROV_X_NAME, TEST2_PROVX_VERSION);
        this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.eclipse.type", "bundle", Version.create((String)"1.0.0"));
        BundlesActionTest.assertEquals((int)7, (int)providedCapabilities.size());
        Map prop = bundleIu.getProperties();
        BundlesActionTest.assertTrue((boolean)((String)prop.get("org.eclipse.equinox.p2.name")).toString().equalsIgnoreCase("%bundleName"));
        BundlesActionTest.assertTrue((boolean)((String)prop.get("org.eclipse.equinox.p2.provider")).toString().equalsIgnoreCase("%providerName"));
        Collection data = bundleIu.getTouchpointData();
        boolean found = false;
        for (ITouchpointData td : data) {
            String body;
            ITouchpointInstruction configure = td.getInstruction("configure");
            if (configure == null || (body = configure.getBody()) == null || body.indexOf("download.eclipse.org/releases/ganymede") <= 0) continue;
            found = true;
        }
        BundlesActionTest.assertFalse((boolean)found);
    }

    private void verifyBundle3() {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(TEST3_PROV_BUNDLE_NAME, "root"));
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit bundleIu = (IInstallableUnit)ius.get(0);
        IUpdateDescriptor updateDescriptor = bundleIu.getUpdateDescriptor();
        String name = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange range = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        String description = updateDescriptor.getDescription();
        int severity = updateDescriptor.getSeverity();
        VersionRange expectedRange = new VersionRange("(0.0.1," + BUNDLE3_VERSION + "]");
        BundlesActionTest.assertEquals((String)TEST3_PROV_BUNDLE_NAME, (String)name);
        BundlesActionTest.assertEquals((Object)expectedRange, (Object)range);
        BundlesActionTest.assertEquals((String)"Some description about this update", (String)description.trim());
        BundlesActionTest.assertEquals((int)8, (int)severity);
    }

    private void verifyBundle4() {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(TEST4_PROV_BUNDLE_NAME, "root"));
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit bundleIu = (IInstallableUnit)ius.get(0);
        BundlesActionTest.assertNotNull((Object)bundleIu);
        BundlesActionTest.assertEquals((Object)bundleIu.getVersion(), (Object)BUNDLE4_VERSION);
        Collection requirements = bundleIu.getRequirements();
        this.verifyRequirement(requirements, "java.package", TEST4_REQ_PACKAGE_OPTIONAL_NAME, DEFAULT_VERSION_RANGE, null, 0, 1, false);
        this.verifyRequirement(requirements, "java.package", TEST4_REQ_PACKAGE_OPTGREEDY_NAME, DEFAULT_VERSION_RANGE, null, 0, 1, true);
        this.verifyRequirement(requirements, "osgi.bundle", TEST4_REQ_BUNDLE_OPTIONAL_NAME, DEFAULT_VERSION_RANGE, null, 0, 1, false);
        this.verifyRequirement(requirements, "osgi.bundle", TEST4_REQ_BUNDLE_OPTGREEDY_NAME, DEFAULT_VERSION_RANGE, null, 0, 1, true);
        BundlesActionTest.assertEquals((int)4, (int)requirements.size());
    }

    private void verifyBundle5() {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(TEST5_PROV_BUNDLE_NAME, "root"));
        BundlesActionTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit bundle5IU = (IInstallableUnit)ius.get(0);
        Collection requirements = bundle5IU.getRequirements();
        this.verifyRequirement(requirements, OSGI_EE, "(|(&(osgi.ee=JavaSE)(version=1.4))(&(osgi.ee=CDC/Foundation)(version=1.1)))", null, 1, 1, true);
        this.verifyRequirement(requirements, "bar", "foo", VersionRange.emptyRange, null, 6, 7, true);
        BundlesActionTest.assertEquals((int)2, (int)requirements.size());
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.artifactRepository != null) {
            this.artifactRepository.removeAll((IProgressMonitor)new NullProgressMonitor());
            this.artifactRepository = null;
        }
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        super.insertPublisherInfoBehavior();
        HashMap<String, String> sarProperties = new HashMap<String, String>();
        sarProperties.put("key1", "value1");
        sarProperties.put("key2", "value2");
        HashMap<String, String> sdkProperties = new HashMap<String, String>();
        sdkProperties.put("key1", "value1");
        sdkProperties.put("key2", "value2");
        EasyMock.expect((Object)this.publisherInfo.getArtifactRepository()).andReturn((Object)this.artifactRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactOptions()).andReturn((Object)7).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, null, null, ICapabilityAdvice.class)).andReturn(new ArrayList()).anyTimes();
        this.expectOtherAdviceQueries(TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION);
        this.expectPropertyAdviceQuery(TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION, sarProperties);
        this.expectUpdateDescriptorAdviceQuery(TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION, null);
        this.expectTouchpointAdviceQuery(TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION, this.tpAdvice1);
        this.expectOtherAdviceQueries(TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION);
        this.expectPropertyAdviceQuery(TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION, sdkProperties);
        this.expectUpdateDescriptorAdviceQuery(TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION, null);
        this.expectTouchpointAdviceQuery(TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION, this.tpAdvice2);
        this.expectOtherAdviceQueries(TEST3_PROV_BUNDLE_NAME, BUNDLE3_VERSION);
        this.expectPropertyAdviceQuery(TEST3_PROV_BUNDLE_NAME, BUNDLE3_VERSION, sarProperties);
        this.expectUpdateDescriptorAdviceQuery(TEST3_PROV_BUNDLE_NAME, BUNDLE3_VERSION, this.udAdvice3);
        this.expectTouchpointAdviceQuery(TEST3_PROV_BUNDLE_NAME, BUNDLE3_VERSION, null);
        this.expectOtherAdviceQueries(TEST4_PROV_BUNDLE_NAME, BUNDLE4_VERSION);
        this.expectPropertyAdviceQuery(TEST4_PROV_BUNDLE_NAME, BUNDLE4_VERSION, null);
        this.expectUpdateDescriptorAdviceQuery(TEST4_PROV_BUNDLE_NAME, BUNDLE4_VERSION, null);
        this.expectTouchpointAdviceQuery(TEST4_PROV_BUNDLE_NAME, BUNDLE4_VERSION, null);
        this.expectCapabilityAdviceQuery(TEST5_PROV_BUNDLE_NAME, BUNDLE5_VERSION, this.capAdvice5);
        this.expectOtherAdviceQueries(TEST5_PROV_BUNDLE_NAME, BUNDLE5_VERSION);
        this.expectPropertyAdviceQuery(TEST5_PROV_BUNDLE_NAME, BUNDLE5_VERSION, sarProperties);
        this.expectUpdateDescriptorAdviceQuery(TEST5_PROV_BUNDLE_NAME, BUNDLE5_VERSION, null);
        this.expectTouchpointAdviceQuery(TEST5_PROV_BUNDLE_NAME, BUNDLE5_VERSION, null);
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)AdviceMatcher.adviceMatches(TEST1_PROVBUNDLE_NAME, BUNDLE1_VERSION, ITouchpointAdvice.class), (Object)((IPublisherAdvice)EasyMock.capture(this.tpAdvice1))));
        EasyMock.expectLastCall().anyTimes();
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)AdviceMatcher.adviceMatches(TEST2_PROV_BUNDLE_NAME, BUNDLE2_VERSION, ITouchpointAdvice.class), (Object)((IPublisherAdvice)EasyMock.capture(this.tpAdvice2))));
        EasyMock.expectLastCall().anyTimes();
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)AdviceMatcher.adviceMatches(TEST3_PROV_BUNDLE_NAME, BUNDLE3_VERSION, AdviceFileAdvice.class), (Object)((IPublisherAdvice)EasyMock.capture(this.udAdvice3))));
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)AdviceMatcher.adviceMatches(TEST5_PROV_BUNDLE_NAME, BUNDLE5_VERSION, AdviceFileAdvice.class), (Object)((IPublisherAdvice)EasyMock.capture(this.capAdvice5))));
        EasyMock.expectLastCall().anyTimes();
    }

    private void expectOtherAdviceQueries(String bundleName, Version bundleVersion) {
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, bundleName, bundleVersion, ICapabilityAdvice.class)).andReturn((Object)Collections.EMPTY_LIST);
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, bundleName, bundleVersion, IAdditionalInstallableUnitAdvice.class)).andReturn((Object)Collections.EMPTY_LIST);
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, true, bundleName, bundleVersion, IBundleShapeAdvice.class)).andReturn(null);
    }

    private void expectCapabilityAdviceQuery(String bundleName, Version bundleVersion, Collection<ICapabilityAdvice> answer) {
        if (answer == null) {
            answer = Collections.emptyList();
        }
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, bundleName, bundleVersion, ICapabilityAdvice.class)).andReturn(answer);
    }

    private void expectUpdateDescriptorAdviceQuery(String bundleName, Version bundleVersion, Collection<IUpdateDescriptorAdvice> answer) {
        if (answer == null) {
            answer = Collections.emptyList();
        }
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, bundleName, bundleVersion, IUpdateDescriptorAdvice.class)).andReturn(answer);
    }

    private void expectTouchpointAdviceQuery(String bundleName, Version bundleVersion, Collection<ITouchpointAdvice> answer) {
        if (answer == null) {
            answer = Collections.emptyList();
        }
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, bundleName, bundleVersion, ITouchpointAdvice.class)).andReturn(answer).anyTimes();
    }

    private void expectPropertyAdviceQuery(String bundleName, Version bundleVersion, Map<String, String> answer) {
        List<Object> propertyAdvices = answer != null ? Collections.singletonList(this.createPropertyAdvice(answer)) : Collections.emptyList();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, bundleName, bundleVersion, IPropertyAdvice.class)).andReturn(propertyAdvices).times(2);
    }

    private IPropertyAdvice createPropertyAdvice(Map<String, String> properties) {
        IPropertyAdvice mockAdvice = (IPropertyAdvice)EasyMock.createMock(IPropertyAdvice.class);
        EasyMock.expect((Object)mockAdvice.getInstallableUnitProperties((MetadataFactory.InstallableUnitDescription)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.expect((Object)mockAdvice.getArtifactProperties((IInstallableUnit)EasyMock.anyObject(), (IArtifactDescriptor)EasyMock.anyObject())).andReturn(properties).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockAdvice});
        return mockAdvice;
    }

    public void testDynamicImport() throws Exception {
        File testData = BundlesActionTest.getTestData("dymamicImport", "testData/dynamicImport");
        IInstallableUnit iu = BundlesAction.createBundleIU((BundleDescription)BundlesAction.createBundleDescription((File)testData), null, (IPublisherInfo)new PublisherInfo());
        Collection requirements = iu.getRequirements();
        this.verifyRequirement(requirements, OSGI_EE, "(&(osgi.ee=JavaSE)(version=1.6))", null, 1, 1, true);
        BundlesActionTest.assertEquals((int)1, (int)requirements.size());
    }

    public void testPublishBundlesWhereOneBundleIsInvalid() throws Exception {
        File[] bundleLocations = new File(TestActivator.getTestDataFolder(), "bug331683").listFiles();
        this.testAction = new BundlesAction(bundleLocations);
        this.setupPublisherResult();
        PublisherInfo info = new PublisherInfo();
        IStatus status = this.testAction.perform((IPublisherInfo)info, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)status, StatusMatchers.errorStatus());
        List<IStatus> childStatuses = Arrays.asList(status.getChildren());
        Assert.assertThat(childStatuses, (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"The manifest line \"foo\" is invalid; it has no colon ':' character after the header key."))));
        Assert.assertThat((Object)childStatuses.size(), (Matcher)CoreMatchers.is((Object)1));
        Collection ius = this.publisherResult.getIUs("org.eclipse.p2.test.validManifest", "root");
        Assert.assertThat((Object)ius.size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

