/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class MD5GenerationTest
extends AbstractProvisioningTest {
    public void testGenerationFile() {
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IArtifactKey)new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0)), (File)MD5GenerationTest.getTestData("Artifact to generate from", "testData/artifactRepo/simpleWithMD5/plugins/aaPlugin_1.0.0.jar"));
        MD5GenerationTest.assertEquals((String)"50d4ea58b02706ab373a908338877e02", (String)ad.getProperty("download.md5"));
    }

    public void testGenerationFile_emptyPublisherInfo() {
        ArtifactKey key = new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0));
        PublisherInfo publisherInfo = new PublisherInfo();
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IPublisherInfo)publisherInfo, (IArtifactKey)key, (File)MD5GenerationTest.getTestData("Artifact to generate from", "testData/artifactRepo/simpleWithMD5/plugins/aaPlugin_1.0.0.jar"));
        MD5GenerationTest.assertEquals((String)"50d4ea58b02706ab373a908338877e02", (String)ad.getProperty("download.md5"));
    }

    public void testGenerationFile_noMd5() {
        ArtifactKey key = new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0));
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(8);
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IPublisherInfo)publisherInfo, (IArtifactKey)key, (File)MD5GenerationTest.getTestData("Artifact to generate from", "testData/artifactRepo/simpleWithMD5/plugins/aaPlugin_1.0.0.jar"));
        MD5GenerationTest.assertNull((Object)ad.getProperty("download.md5"));
    }

    public void testGenerationFolder() {
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IArtifactKey)new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0)), (File)MD5GenerationTest.getTestData("Artifact to generate from", "testData/artifactRepo/simpleWithMD5/plugins/"));
        MD5GenerationTest.assertNull((Object)ad.getProperty("download.md5"));
    }

    public void testGenerationNoFolder() {
        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IArtifactKey)new ArtifactKey("classifierTest", "idTest", Version.createOSGi((int)1, (int)0, (int)0)), null);
        MD5GenerationTest.assertNull((Object)ad.getProperty("download.md5"));
    }
}

