/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProductActionWithJRELocationTest
extends AbstractProvisioningTest {
    public void testWithJRELocationFolder() throws Exception {
        File productFileLocation = TestData.getFile("ProductActionTest", "productWithLicense.product");
        File jreLocation = TestData.getFile("JREActionTest", "packageVersions");
        ArrayList<IProvidedCapability> expectedProvidedCapabilities = new ArrayList<IProvidedCapability>();
        expectedProvidedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", null));
        expectedProvidedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", (Version)Version.create((String)"1.0.0")));
        this.testTemplate(productFileLocation, jreLocation, "a.jre.test", Version.create((String)"1.0.0"), expectedProvidedCapabilities);
    }

    public void testWithJREProfile() throws Exception {
        File productFileLocation = TestData.getFile("ProductActionTest", "productWithLicense.product");
        File jreLocation = TestData.getFile("JREActionTest", "packageVersions/test-1.0.0.profile");
        ArrayList<IProvidedCapability> expectedProvidedCapabilities = new ArrayList<IProvidedCapability>();
        expectedProvidedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", null));
        expectedProvidedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", (Version)Version.create((String)"1.0.0")));
        this.testTemplate(productFileLocation, jreLocation, "a.jre.test", Version.create((String)"1.0.0"), expectedProvidedCapabilities);
    }

    private void testTemplate(File productFileLocation, File jreLocation, String jreIuName, Version jreIuVersion, Collection<IProvidedCapability> expectedProvidedCapabilities) throws Exception {
        ProductFile productFile = new ProductFile(productFileLocation.getCanonicalPath());
        ProductAction testAction = new ProductAction(null, (IProductDescriptor)productFile, "tooling", null, jreLocation);
        PublisherResult publisherResult = new PublisherResult();
        IStatus status = testAction.perform((IPublisherInfo)new PublisherInfo(), (IPublisherResult)publisherResult, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        Collection ius = publisherResult.getIUs(jreIuName, "root");
        ProductActionWithJRELocationTest.assertEquals((int)1, (int)ius.size());
        IInstallableUnit jreIU = (IInstallableUnit)ius.iterator().next();
        ProductActionWithJRELocationTest.assertEquals((Object)jreIuVersion, (Object)jreIU.getVersion());
        Collection providedCapabilities = jreIU.getProvidedCapabilities();
        for (IProvidedCapability expectedProvidedCapability : expectedProvidedCapabilities) {
            ProductActionWithJRELocationTest.assertTrue((String)("Expected capability " + expectedProvidedCapability + " was not found in published JRE"), (boolean)this.verifyProvidedCapabilities(providedCapabilities, expectedProvidedCapability));
        }
    }

    private boolean verifyProvidedCapabilities(Collection<IProvidedCapability> providedCapabilities, IProvidedCapability expectedProvidedCapability) {
        for (IProvidedCapability iProvidedCapability : providedCapabilities) {
            if (!iProvidedCapability.equals((Object)expectedProvidedCapability)) continue;
            return true;
        }
        return false;
    }
}

