/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;

public class ProductFileAdviceTest
extends AbstractProvisioningTest {
    String productFileLocation = null;
    ProductFile productFile = null;
    ProductFileAdvice productFileAdviceWin32 = null;
    String productFileLocation2 = null;
    ProductFile productFile2 = null;
    ProductFileAdvice productFileAdvice2 = null;
    String configFile = "/org.eclipse.equinox.p2.tests/testData/ProductActionTest/productWithConfig/config.ini";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.productFileLocation = TestData.getFile("ProductActionTest/productWithConfig", "sample.product").toString();
        this.productFile = new ProductFile(this.productFileLocation);
        this.productFileAdviceWin32 = new ProductFileAdvice((IProductDescriptor)this.productFile, "x86.win32.*");
        this.productFileLocation2 = TestData.getFile("ProductActionTest", "productFileActionTest.product").toString();
        this.productFile2 = new ProductFile(this.productFileLocation2);
        this.productFileAdvice2 = new ProductFileAdvice((IProductDescriptor)this.productFile2, "x86.win32.*");
    }

    public void testGetProgramArguments() {
        String[] programArgumentsWin32 = this.productFileAdviceWin32.getProgramArguments();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)3, (int)programArgumentsWin32.length);
        ProductFileAdviceTest.assertEquals((String)"1.1", (String)"programArg", (String)programArgumentsWin32[0]);
        ProductFileAdviceTest.assertEquals((String)"1.2", (String)"-name", (String)programArgumentsWin32[1]);
        ProductFileAdviceTest.assertEquals((String)"1.3", (String)"My Name", (String)programArgumentsWin32[2]);
        String[] programArguments2 = this.productFileAdvice2.getProgramArguments();
        ProductFileAdviceTest.assertEquals((String)"2.0", (int)2, (int)programArguments2.length);
        ProductFileAdviceTest.assertEquals((String)"2.1", (String)"-product", (String)programArguments2[0]);
        ProductFileAdviceTest.assertEquals((String)"2.2", (String)"com,ma", (String)programArguments2[1]);
    }

    public void testGetVMArguments() {
        String[] vmArgumentsWin32 = this.productFileAdviceWin32.getVMArguments();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)2, (int)vmArgumentsWin32.length);
        ProductFileAdviceTest.assertEquals((String)"1.1", (String)"vmArg", (String)vmArgumentsWin32[0]);
        ProductFileAdviceTest.assertEquals((String)"1.2", (String)"-Dfoo=b a r", (String)vmArgumentsWin32[1]);
        String[] vmArguments2 = this.productFileAdvice2.getVMArguments();
        ProductFileAdviceTest.assertEquals((String)"2.0", (int)1, (int)vmArguments2.length);
        ProductFileAdviceTest.assertEquals((String)"2.1", (String)"-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=8272", (String)vmArguments2[0]);
    }

    public void testGetBundles() {
        BundleInfo[] bundles = this.productFileAdviceWin32.getBundles();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)3, (int)bundles.length);
        int i = 0;
        while (i < 3) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.equinox.common")) {
                ProductFileAdviceTest.assertEquals((int)2, (int)bundles[i].getStartLevel());
                ProductFileAdviceTest.assertEquals((boolean)true, (boolean)bundles[i].isMarkedAsStarted());
            } else if (!bundles[i].getSymbolicName().equals("org.eclipse.core.runtime")) {
                if (bundles[i].getSymbolicName().equals("org.eclipse.swt.win32.win32.x86")) {
                    ProductFileAdviceTest.assertEquals((int)-1, (int)bundles[i].getStartLevel());
                    ProductFileAdviceTest.assertEquals((boolean)false, (boolean)bundles[i].isMarkedAsStarted());
                } else {
                    ProductFileAdviceTest.fail((String)("unknown bundle: " + bundles[i].getSymbolicName()));
                }
            }
            ++i;
        }
        bundles = this.productFileAdvice2.getBundles();
        ProductFileAdviceTest.assertEquals((String)"2.0", (int)1, (int)bundles.length);
        i = 0;
        while (i < 1) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.core.commands")) {
                ProductFileAdviceTest.assertTrue((String)"2.1", (bundles[i].getStartLevel() == 2 ? 1 : 0) != 0);
                ProductFileAdviceTest.assertTrue((String)"2.2", (!bundles[i].isMarkedAsStarted() ? 1 : 0) != 0);
            } else {
                ProductFileAdviceTest.fail((String)("unknown bundle: " + bundles[i].getSymbolicName()));
            }
            ++i;
        }
    }

    public void testBoundedVersionConfigurations() throws Exception {
        String location = TestData.getFile("ProductActionTest", "boundedVersionConfigurations.product").toString();
        ProductFile product = new ProductFile(location);
        ProductFileAdvice advice = new ProductFileAdvice((IProductDescriptor)product, "x86.win32.*");
        BundleInfo[] bundles = advice.getBundles();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)2, (int)bundles.length);
        int i = 0;
        while (i < 2) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.core.commands")) {
                ProductFileAdviceTest.assertEquals((int)2, (int)bundles[i].getStartLevel());
                ProductFileAdviceTest.assertEquals((boolean)true, (boolean)bundles[i].isMarkedAsStarted());
            } else if (bundles[i].getSymbolicName().equals("org.eclipse.core.runtime")) {
                ProductFileAdviceTest.assertTrue((String)"1.1", (bundles[i].getStartLevel() == 2 ? 1 : 0) != 0);
                ProductFileAdviceTest.assertTrue((String)"1.2", (boolean)bundles[i].isMarkedAsStarted());
            } else {
                ProductFileAdviceTest.fail((String)("unknown bundle: " + bundles[i].getSymbolicName()));
            }
            ++i;
        }
    }

    public void testUnboundedVersionConfigurations() throws Exception {
        String location = TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString();
        ProductFile product = new ProductFile(location);
        ProductFileAdvice advice = new ProductFileAdvice((IProductDescriptor)product, "x86.win32.*");
        BundleInfo[] bundles = advice.getBundles();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)2, (int)bundles.length);
        int i = 0;
        while (i < 2) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.core.commands")) {
                ProductFileAdviceTest.assertEquals((int)2, (int)bundles[i].getStartLevel());
                ProductFileAdviceTest.assertEquals((boolean)true, (boolean)bundles[i].isMarkedAsStarted());
            } else if (bundles[i].getSymbolicName().equals("org.eclipse.core.runtime")) {
                ProductFileAdviceTest.assertTrue((String)"1.1", (bundles[i].getStartLevel() == 2 ? 1 : 0) != 0);
                ProductFileAdviceTest.assertTrue((String)"1.2", (boolean)bundles[i].isMarkedAsStarted());
            } else {
                ProductFileAdviceTest.fail((String)("unknown bundle: " + bundles[i].getSymbolicName()));
            }
            ++i;
        }
    }

    public void testGetProperties() {
        Map properties = this.productFileAdviceWin32.getProperties();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)7, (int)properties.size());
        ProductFileAdviceTest.assertEquals((String)"1.2", (String)"bar", (String)((String)properties.get("foo")));
        ProductFileAdviceTest.assertEquals((String)"1.3", (String)"", (String)((String)properties.get("foo1")));
        ProductFileAdviceTest.assertEquals((String)"1.4", (String)"true", (String)((String)properties.get("osgi.sharedConfiguration.area.readOnly")));
        ProductFileAdviceTest.assertEquals((String)"1.5", (String)"/d/sw/java64/jdk1.6.0_03/bin/java", (String)((String)properties.get("eclipse.vm")));
        ProductFileAdviceTest.assertEquals((String)"1.6", (String)"test.product", (String)((String)properties.get("eclipse.product")));
        ProductFileAdviceTest.assertEquals((String)"1.7", (String)"test.app", (String)((String)properties.get("eclipse.application")));
        ProductFileAdviceTest.assertEquals((String)"1.1", (String)"platform:/base/plugins/org.eclipse.equinox.p2.tests", (String)((String)properties.get("osgi.splashPath")));
        properties = this.productFileAdvice2.getProperties();
        ProductFileAdviceTest.assertEquals((String)"2.0", (int)0, (int)properties.size());
    }

    public void testGetExecutableName() {
        ProductFileAdviceTest.assertEquals((String)"1.0", (String)"sample", (String)this.productFileAdviceWin32.getExecutableName());
        ProductFileAdviceTest.assertEquals((String)"2.0", null, (String)this.productFileAdvice2.getExecutableName());
    }

    public void testGetProductFile() {
        ProductFileAdviceTest.assertEquals((String)"1.0", (Object)this.productFile, (Object)this.productFileAdviceWin32.getProductFile());
        ProductFileAdviceTest.assertEquals((String)"2.0", (Object)this.productFile2, (Object)this.productFileAdvice2.getProductFile());
    }

    public void testGetIcons() {
        String[] icons = this.productFileAdviceWin32.getIcons();
        String absolutePath = new File(this.productFile.getLocation().getParentFile(), "test/icon.bmp").getAbsolutePath();
        ProductFileAdviceTest.assertEquals((String)"1.0", (int)1, (int)icons.length);
        ProductFileAdviceTest.assertEquals((String)"1.1", (String)absolutePath, (String)icons[0]);
        icons = this.productFileAdvice2.getIcons();
        absolutePath = new File(this.productFile2.getLocation().getParentFile(), "icon.bmp").getAbsolutePath();
        ProductFileAdviceTest.assertEquals((String)"2.0", (int)1, (int)icons.length);
        ProductFileAdviceTest.assertEquals((String)"2.1", (String)absolutePath, (String)icons[0]);
    }

    public void testSimpleConfiguratorConfigURL() throws Exception {
        File rootFolder = this.getTestFolder("simpleConfiguratorConfigURL");
        File sampleProduct = new File(rootFolder, "sample.product");
        ProductFileAdviceTest.copy("Copying sample.product", TestData.getFile("ProductActionTest/productWithConfig", "sample.product"), sampleProduct);
        Properties configProperties = new Properties();
        configProperties.put("org.eclipse.equinox.simpleconfigurator.configUrl", "file:org.eclipse.equinox.simpleconfigurator/bundles.info");
        configProperties.put("osgi.bundles", "org.eclipse.equinox.simpleconfigurator@1:start");
        ProductFileAdviceTest.writeProperties(new File(rootFolder, "config.ini"), configProperties);
        StringBuffer buffer = new StringBuffer();
        buffer.append("org.eclipse.equinox.common,3.5.100.v20090817,plugins/org.eclipse.equinox.common_3.5.100.v20090817.jar,2,true\n");
        buffer.append("org.eclipse.equinox.simpleconfigurator,1.0.200.v20090729-1800,plugins/org.eclipse.equinox.simpleconfigurator_1.0.200.v20090729-1800.jar,1,true\n");
        ProductFileAdviceTest.writeBuffer(new File(rootFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info"), buffer);
        ProductFile product = new ProductFile(sampleProduct.getCanonicalPath());
        ProductFileAdvice advice = new ProductFileAdvice((IProductDescriptor)product, "x86.win32.win32");
        BundleInfo[] bundles = advice.getBundles();
        int i = 0;
        while (i < 2) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.equinox.common")) {
                ProductFileAdviceTest.assertEquals((String)"equinox.common start level", (int)2, (int)bundles[i].getStartLevel());
                ProductFileAdviceTest.assertEquals((String)"equinox.common started", (boolean)true, (boolean)bundles[i].isMarkedAsStarted());
            }
            ++i;
        }
    }

    public void testConfigNullLauncher() throws Exception {
        File root = this.getTestFolder("configNullLauncher");
        File testProduct = new File(root, "test.product");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<product id=\"test.product\" version=\"1\" useFeatures=\"false\">\t\n");
        buffer.append("   <configIni use=\"default\">\t\t\t\t\t\t\t\t\t\t\n");
        buffer.append("      <win32>config.ini</win32>\t\t\t\t\t\t\t\t\t\t\n");
        buffer.append("   </configIni>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        buffer.append("   <plugins>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        buffer.append("      <plugin id=\"org.eclipse.core.runtime\" version=\"1.0.4\"/>\t\n");
        buffer.append("      <plugin id=\"org.eclipse.equinox.simpleconfigurator\" />\t\t\n");
        buffer.append("   </plugins>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        buffer.append("</product>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        ProductFileAdviceTest.writeBuffer(testProduct, buffer);
        Properties configProperties = new Properties();
        configProperties.put("osgi.bundles", "org.eclipse.equinox.simpleconfigurator@1:start");
        configProperties.put("eclipse.application", "test.application");
        configProperties.put("osgi.instance.area.default", "@user.home/workspace");
        ProductFileAdviceTest.writeProperties(new File(root, "config.ini"), configProperties);
        ProductFile product = new ProductFile(testProduct.getCanonicalPath());
        ProductFileAdvice advice = new ProductFileAdvice((IProductDescriptor)product, "x86.win32.win32");
        BundleInfo[] bundles = advice.getBundles();
        ProductFileAdviceTest.assertEquals((String)"bundlers length", (int)2, (int)bundles.length);
        Map adviceProperties = advice.getProperties();
        ProductFileAdviceTest.assertEquals((String)"instance.area.default", (String)"@user.home/workspace", (String)((String)adviceProperties.get("osgi.instance.area.default")));
        ProductFileAdviceTest.assertEquals((String)"eclipse.application", (String)"test.application", (String)((String)adviceProperties.get("eclipse.application")));
        ProductFileAdviceTest.assertEquals((String)"eclipse.product", (String)"test.product", (String)((String)adviceProperties.get("eclipse.product")));
    }
}

