/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.actions.IRootFilesAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootFilesAction;
import org.eclipse.equinox.p2.publisher.actions.RootFilesAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;

public class RootFilesActionTest
extends ActionTest {
    private static final int INCLUDES_ROOT = 1;
    private static final int ARTIFACT_REPO = 2;
    private static final int INCLUDES_FILES = 4;
    private static final int EXCLUDE_INCLUDED = 8;
    private static final int EXCLUDES_UNUSED = 16;
    private static final int ALL = 31;
    protected static String topArg = "sdk.rootfiles.win32.win32.x86";
    protected String rootExclusions = null;
    protected IArtifactRepository artifactRepository;
    protected String idArg = "sdk";
    protected Version versionArg = Version.create((String)"3.4.0.i0305");
    private File root = new File(TestActivator.getTestDataFolder(), "RootFilesActionTest/eclipse");
    private File[] includedFiles;
    private File[] excludedFiles;
    private Collection<IRootFilesAdvice> adviceCollection;
    private String FILE1 = "level1/level2/file1.jar";
    private String FILE2 = "level1/level2/level3/file1.jar";
    private int testArg;

    public void testAll() throws Exception {
        int i = 0;
        while (i < 31) {
            this.setupTestCase(i);
            this.setupPublisherInfo();
            this.setupPublisherResult();
            this.testAction = new RootFilesAction(this.publisherInfo, this.idArg, this.versionArg, this.flavorArg);
            RootFilesActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
            this.verifyRepositoryContents(i);
            this.cleanup();
            ++i;
        }
    }

    @Override
    public void insertPublisherInfoBehavior() {
        EasyMock.expect((Object)this.publisherInfo.getArtifactRepository()).andReturn((Object)this.artifactRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactOptions()).andReturn((Object)7).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(this.configSpec, true, null, null, IRootFilesAdvice.class)).andReturn(this.adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(this.configSpec, false, String.valueOf(this.flavorArg) + topArg, this.versionArg, ITouchpointAdvice.class)).andReturn(null).anyTimes();
    }

    private void setupTestCase(int testArg) throws Exception {
        this.testArg = testArg;
        this.adviceCollection = new ArrayList<IRootFilesAdvice>();
        this.topLevel = AbstractPublisherAction.getArrayFromString((String)topArg, (String)",");
        if ((testArg & 2) > 0) {
            this.artifactRepository = new TestArtifactRepository(RootFilesActionTest.getAgent());
        }
        if ((testArg & 4) > 0) {
            this.adviceCollection.add((IRootFilesAdvice)new RootFilesAdvice(null, this.root.listFiles(), null, this.configSpec));
        }
        if ((testArg & 1) > 0) {
            this.adviceCollection.add((IRootFilesAdvice)new RootFilesAdvice(this.root, null, null, this.configSpec));
        }
        if ((testArg & 8) > 0 && this.includedFiles != null && this.includedFiles.length > 1) {
            this.excludedFiles = new File[1];
            this.excludedFiles[0] = this.includedFiles[0];
            this.adviceCollection.add((IRootFilesAdvice)new RootFilesAdvice(null, null, this.excludedFiles, this.configSpec));
        }
        if ((testArg & 0x10) > 0) {
            this.excludedFiles = new File[1];
            this.excludedFiles[0] = new File(this.root, "/eclipse/notHere");
            this.adviceCollection.add((IRootFilesAdvice)new RootFilesAdvice(null, null, this.excludedFiles, this.configSpec));
        }
        this.setupPublisherInfo();
    }

    private void verifyRepositoryContents(int arg) throws Exception {
        boolean includeRoot;
        boolean artifactRepo = (arg & 2) > 0;
        boolean includeFiles = (arg & 4) > 0;
        boolean bl = includeRoot = (arg & 1) > 0;
        if (!artifactRepo || !includeFiles) {
            return;
        }
        IArtifactKey key = ArtifactKey.parse((String)"binary,sdk.rootfiles.win32.win32.x86,3.4.0.i0305");
        RootFilesActionTest.assertTrue((boolean)this.artifactRepository.contains(key));
        Map<String, Object[]> fileList = this.getRepoFiles(new HashMap<String, Object[]>());
        ZipInputStream zis = ((TestArtifactRepository)this.artifactRepository).getZipInputStream(key);
        TestData.assertContains(fileList, zis, includeRoot || !includeFiles || !artifactRepo);
    }

    private Map<String, Object[]> getRepoFiles(Map<String, Object[]> map) {
        if ((this.testArg & 4) > 0) {
            map = this.addEntry(map, "simpleconfigurator.source.jar");
            map = this.addEntry(map, this.FILE1);
            map = this.addEntry(map, this.FILE2);
        }
        return map;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.artifactRepository != null) {
            this.artifactRepository.removeAll((IProgressMonitor)new NullProgressMonitor());
        }
        this.artifactRepository = null;
        this.excludedFiles = null;
        if (this.adviceCollection != null) {
            this.adviceCollection.clear();
        }
        if (this.includedFiles != null) {
            this.includedFiles = null;
        }
        this.adviceCollection = null;
    }

    protected String toArgString(int arg) {
        String result = "";
        if ((arg & 1) > 0) {
            result = String.valueOf(result) + " INCLUDES_ROOT";
        }
        if ((arg & 0x10) > 0) {
            result = String.valueOf(result) + " EXCLUDES_UNUSED";
        }
        if ((arg & 2) > 0) {
            result = String.valueOf(result) + " ARTIFACT_REPO";
        }
        if ((arg & 4) > 0) {
            result = String.valueOf(result) + " INCLUDES_FILES";
        }
        if ((arg & 8) > 0) {
            result = String.valueOf(result) + " EXCLUDE_INCLUDED";
        }
        return result;
    }

    private Map<String, Object[]> addEntry(Map<String, Object[]> map, String fileEntry) {
        try {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            File contentBytes = new File(this.root, fileEntry);
            FileUtils.copyStream((InputStream)new FileInputStream(contentBytes), (boolean)false, (OutputStream)content, (boolean)true);
            boolean includeRootInEntry = (this.testArg & 1) > 0;
            String entry = includeRootInEntry ? new File(fileEntry).getPath() : new File(fileEntry).getName();
            entry = new Path(entry).toString();
            map.put(entry, new Object[]{contentBytes, content.toByteArray()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }
}

