/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.actions.VersionAdvice;
import org.eclipse.equinox.p2.tests.TestData;

public class VersionAdviceTest
extends TestCase {
    public void testBadVersionPropertyFile() {
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load(null, "some random string");
    }

    public void testLoadNullVersionAdvice() throws Exception {
        String versionAdviceFoo = TestData.getFile("publisher", "versionadvicefoo.prop").toString();
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load(null, versionAdviceFoo);
        VersionAdviceTest.assertEquals((String)"1.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("foo", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"2.0", (Object)Version.create((String)"1.3.1"), (Object)versionAdvice.getVersion("null", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"3.0", (Object)Version.create((String)"1.4.0"), (Object)versionAdvice.getVersion(null, "org.eclipse.tptp"));
    }

    public void testLoadNullVersionAdvice2() throws Exception {
        String versionAdviceFoo = TestData.getFile("publisher", "versionadvicefoo.prop").toString();
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load("null", versionAdviceFoo);
        VersionAdviceTest.assertEquals((String)"1.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("foo", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"2.0", (Object)Version.create((String)"1.3.1"), (Object)versionAdvice.getVersion("null", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"3.0", (Object)Version.create((String)"1.4.0"), (Object)versionAdvice.getVersion(null, "org.eclipse.tptp"));
    }

    public void testOverloadNull() throws Exception {
        String versionAdviceFoo = TestData.getFile("publisher", "versionadvicefoo.prop").toString();
        String versionAdviceBar = TestData.getFile("publisher", "versionadvicebar.prop").toString();
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load(null, versionAdviceFoo);
        versionAdvice.load(null, versionAdviceBar);
        VersionAdviceTest.assertEquals((String)"1.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("foo", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"1.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("foo", "org.apache.commons"));
        VersionAdviceTest.assertEquals((String)"2.0", (Object)Version.create((String)"2.3.1"), (Object)versionAdvice.getVersion("null", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"3.0", (Object)Version.create((String)"1.5.0"), (Object)versionAdvice.getVersion(null, "org.eclipse.tptp"));
    }

    public void testLoadVersionAdviceFoo() throws Exception {
        String versionAdviceFoo = TestData.getFile("publisher", "versionadvicefoo.prop").toString();
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load("foo", versionAdviceFoo);
        VersionAdviceTest.assertEquals((String)"1.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("foo", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"2.0", (Object)Version.create((String)"1.3.1"), (Object)versionAdvice.getVersion("foo", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"3.0", (Object)Version.create((String)"1.4.0"), (Object)versionAdvice.getVersion("foo", "org.eclipse.tptp"));
        VersionAdviceTest.assertEquals((String)"4.0", null, (Object)versionAdvice.getVersion(null, "org.eclipse.tptp"));
    }

    public void testLoadVersionAdviceBar() throws Exception {
        String versionAdviceBar = TestData.getFile("publisher", "versionadvicebar.prop").toString();
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load("bar", versionAdviceBar);
        VersionAdviceTest.assertEquals((String)"1.0", null, (Object)versionAdvice.getVersion("bar", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"2.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("bar", "org.apache.commons"));
        VersionAdviceTest.assertEquals((String)"3.0", (Object)Version.create((String)"2.3.1"), (Object)versionAdvice.getVersion("bar", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"4.0", (Object)Version.create((String)"1.5.0"), (Object)versionAdvice.getVersion("bar", "org.eclipse.tptp"));
    }

    public void testLoadVersionAdviceFooBar() throws Exception {
        String versionAdviceFoo = TestData.getFile("publisher", "versionadvicefoo.prop").toString();
        String versionAdviceBar = TestData.getFile("publisher", "versionadvicebar.prop").toString();
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.load("foo", versionAdviceFoo);
        versionAdvice.load("bar", versionAdviceBar);
        VersionAdviceTest.assertEquals((String)"1.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("foo", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"2.0", (Object)Version.create((String)"1.3.1"), (Object)versionAdvice.getVersion("foo", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"3.0", (Object)Version.create((String)"1.4.0"), (Object)versionAdvice.getVersion("foo", "org.eclipse.tptp"));
        VersionAdviceTest.assertEquals((String)"4.0", null, (Object)versionAdvice.getVersion("bar", "org.apache.http"));
        VersionAdviceTest.assertEquals((String)"5.0", (Object)Version.create((String)"1.6.4.thisisastring"), (Object)versionAdvice.getVersion("bar", "org.apache.commons"));
        VersionAdviceTest.assertEquals((String)"6.0", (Object)Version.create((String)"2.3.1"), (Object)versionAdvice.getVersion("bar", "org.eclipse.cdt"));
        VersionAdviceTest.assertEquals((String)"7.0", (Object)Version.create((String)"1.5.0"), (Object)versionAdvice.getVersion("bar", "org.eclipse.tptp"));
    }
}

