/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ql;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.KeyWithLocale;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IContextExpression;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IExpressionParser;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.Filter;

public class EvaluatorTest
extends AbstractProvisioningTest {
    private static final IExpressionParser parser = ExpressionUtil.getParser();
    private static final IExpressionFactory factory = ExpressionUtil.getFactory();

    public void testArguments() throws Exception {
        IExpression expr = parser.parse("'a' == $0 && 'b' == $1 && 'c' == $2");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(factory.createContext(new Object[]{"a", "b", "c"})));
    }

    public void testAnonymousMember() throws Exception {
        IExpression expr = parser.parse("$0.class == $1");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(factory.createContext(new Object[]{"a", String.class})));
    }

    public void testInstanceOf() throws Exception {
        IExpression expr = parser.parse("$0 ~= $1");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(factory.createContext(new Object[]{4, Number.class})));
    }

    public void testArray() throws Exception {
        IExpression expr = parser.parse("['a', 'b', 'c'].exists(x | x == 'b') && ['a', 'b', 'c'].all(x | 'd' > x)");
        IEvaluationContext ctx = factory.createContext(new Object[0]);
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(ctx));
        expr = parser.parse("['d', 'e', 'f'].exists(x | ['a', 'b', 'c'].exists(y | x > y))");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(ctx));
        expr = parser.parse("[['d', 'e', 'f'], ['h', 'i', 'j']].exists(x | x.all(y | ['a', 'b', 'c'].all(z | y > z)))");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(ctx));
        expr = parser.parse("[['d', 'e', 'f'], ['h', '3', 'j']].exists(x | x.all(y | ['a', 'b', 'c'].exists(z | y > z)))");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(ctx));
        expr = parser.parse("[['d', 'e', 'f'], ['h', 'i', 'j']].all(x | x.all(y | ['a', 'b', 'c'].all(z | y > z)))");
        EvaluatorTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(ctx));
        expr = parser.parse("[['d', 'e', 'f'], ['h', '3', 'j']].all(x | x.all(y | ['a', 'b', 'c'].all(z | y > z)))");
        EvaluatorTest.assertEquals((Object)Boolean.FALSE, (Object)expr.evaluate(ctx));
    }

    public void testLatest() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/multipleversions1");
        IQueryResult result = repo.query(QueryUtil.createQuery((String)"latest(x | x.id == $0)", (Object[])new Object[]{"test.bundle"}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertTrue((EvaluatorTest.queryResultSize(result) == 1 ? 1 : 0) != 0);
    }

    public void testRange() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/multipleversions1");
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((String)"version ~= $0", (Object[])new Object[]{new VersionRange("2.0.0")}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)2);
    }

    public void testProperty() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/multipleversions1");
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((String)"properties.exists(p | boolean(p.value))", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)3);
        result = repo.query(QueryUtil.createMatchQuery((String)"boolean(properties['org.eclipse.equinox.p2.type.group'])", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)3);
        Filter filter = TestActivator.context.createFilter("(org.eclipse.equinox.p2.type.group=true)");
        result = repo.query(QueryUtil.createMatchQuery((String)"properties ~= $0", (Object[])new Object[]{filter}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)3);
    }

    public void testToString() throws Exception {
        String exprString = "select(x | x.id == $0 && (x.version == $1 || x.version == $2)).traverse(set(), _, {requirementsCache, parent | select(parent.requirerements.unique(requirementsCache).select(rc | rc.filter == null || $2 ~= filter(rc.filter)), _, {rcs, child | rcs.exists(rc | child ~= rc)})}).limit(10)";
        IContextExpression expr = factory.contextExpression(parser.parseQuery(exprString), new Object[0]);
        System.out.println(expr.toString());
        EvaluatorTest.assertEquals((String)exprString, (String)expr.toString());
    }

    public void testSomeAPI() throws Exception {
        IExpression item = factory.variable("item");
        IExpression cmp1 = factory.equals(factory.member(item, "id"), factory.indexedParameter(0));
        IExpression cmp2 = factory.equals(factory.at(factory.member(item, "properties"), factory.indexedParameter(1)), factory.indexedParameter(2));
        IExpression lambda = factory.lambda(item, factory.and(new IExpression[]{cmp1, cmp2}));
        IExpression latest = factory.latest(factory.select(factory.variable("everything"), lambda));
        IContextExpression e3 = factory.contextExpression(latest, new Object[]{"test.bundle", "org.eclipse.equinox.p2.type.group", "true"});
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/multipleversions1");
        IQueryResult result = repo.query(QueryUtil.createQuery((IExpression)e3, (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)1);
    }

    public void testPatch() throws Exception {
        IRequirement[][] applicability = new IRequirement[2][2];
        applicability[0][0] = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"javax.wsdl", null, null, (boolean)false, (boolean)false);
        applicability[0][1] = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false);
        applicability[1][0] = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"tooling.source.default", null, null, (boolean)false, (boolean)false);
        applicability[1][1] = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.flavor", (String)"tooling", null, null, (boolean)false, (boolean)false);
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/wsdlTestRepo");
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((String)"$0.exists(rcs | rcs.all(rc | this ~= rc))", (Object[])new Object[]{applicability}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)3);
    }

    public void testPattern() throws Exception {
        IProvidedCapability pc = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"source", null);
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/wsdlTestRepo");
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((String)"id ~= /tooling.*.default/", (Object[])new Object[]{pc}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)3);
    }

    public void testLimit() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/wsdlTestRepo");
        IQueryResult result = repo.query(QueryUtil.createQuery((String)"select(x | x.id ~= /tooling.*/).limit(1)", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)1);
        result = repo.query(QueryUtil.createQuery((String)"select(x | x.id ~= /tooling.*/).limit($0)", (Object[])new Object[]{2}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)2);
    }

    public void testNot() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/wsdlTestRepo");
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((String)"!(id ~= /tooling.*/)", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)4);
    }

    public void testArtifactQuery() throws Exception {
        URI artifactRepo = EvaluatorTest.getTestData("1.1", "/testData/artifactRepo/simple").toURI();
        IArtifactRepositoryManager artifactManager = EvaluatorTest.getArtifactRepositoryManager();
        EvaluatorTest.assertNotNull((Object)artifactManager);
        IArtifactRepository repo = artifactManager.loadRepository(artifactRepo, (IProgressMonitor)new NullProgressMonitor());
        IQueryResult result = repo.query(QueryUtil.createMatchQuery(IArtifactKey.class, (String)"classifier ~= /*/", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertTrue((EvaluatorTest.queryResultSize(result) > 1 ? 1 : 0) != 0);
        Iterator itor = result.iterator();
        while (itor.hasNext()) {
            EvaluatorTest.assertNotNull(itor.next());
        }
        IQueryResult result2 = repo.descriptorQueryable().query(QueryUtil.createMatchQuery(IArtifactDescriptor.class, (String)"artifactKey.classifier ~= /*/", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertTrue((EvaluatorTest.queryResultSize(result2) > 1 ? 1 : 0) != 0);
        Iterator itor2 = result2.iterator();
        while (itor2.hasNext()) {
            EvaluatorTest.assertNotNull(itor2.next());
        }
    }

    public void testClassConstructor() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/wsdlTestRepo");
        IQueryResult result = repo.query(QueryUtil.createQuery((String)"select(x | x ~= class('org.eclipse.equinox.p2.metadata.IInstallableUnitFragment'))", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)4);
        repo = this.getMDR("/testData/galileoM7");
    }

    public void testTouchpoints() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((String)"touchpointType != null && touchpointType.id == 'org.eclipse.equinox.p2.osgi' && touchpointData.exists(t | t.instructions.exists(entry | entry.key == 'zipped'))", (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)616);
    }

    public void testTraverse() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQueryResult result = repo.query(QueryUtil.createQuery((String)"select(x | x.id == $0 && x.version == $1).traverse(parent | parent.requirements.collect(rc | select(iu | iu ~= rc)).flatten())", (Object[])new Object[]{"org.eclipse.sdk.feature.group", Version.create((String)"3.5.0.v20090423-7Q7bA7DPR-wM38__Q4iRsmx9z0KOjbpx3AbyvXd-Uq7J2")}), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)463);
    }

    public void testTraverseWithFilter() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("osgi.os", "linux");
        env.put("osgi.ws", "gtk");
        env.put("osgi.arch", "x86");
        IInstallableUnit envIU = InstallableUnit.contextIU(env);
        IContextExpression expr = factory.contextExpression(parser.parseQuery("select(x | x.id == $0 && x.version == $1).traverse(parent |parent.requirements.select(rc | rc.filter == null || $2 ~= rc.filter).collect(rc | select(iu | iu ~= rc)).flatten())"), new Object[]{"org.eclipse.sdk.feature.group", Version.create((String)"3.5.0.v20090423-7Q7bA7DPR-wM38__Q4iRsmx9z0KOjbpx3AbyvXd-Uq7J2"), envIU});
        IQuery query = QueryUtil.createQuery((IExpression)expr, (Object[])new Object[0]);
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IQueryResult result = repo.query(query, (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)411);
    }

    public void testCommonRequirements() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IInstallableUnit envIU = InstallableUnit.contextIU((String)"gtk", (String)"linux", (String)"x86");
        IContextExpression expr = factory.contextExpression(parser.parseQuery("select(x | x.id == $0 && x.version == $1).traverse(parent |parent.requirements.select(rc | rc.filter == null || $4 ~= rc.filter).collect(rc | select(iu | iu ~= rc)).flatten()).intersect(select(x | x.id == $2 && x.version == $3).traverse(parent |parent.requirements.select(rc | rc.filter == null || $4 ~= rc.filter).collect(rc | select(iu | iu ~= rc)).flatten()))"), new Object[]{"org.eclipse.pde.feature.group", Version.create((String)"3.5.0.v20090123-7Z7YF8NFE-z0VXhWU26Hu8gY"), "org.eclipse.gmf.feature.group", Version.create((String)"1.1.1.v20090114-0940-7d8B0FXwkKwFanGNHeHHq8ymBgZ"), envIU});
        IQuery query = QueryUtil.createQuery((IExpression)expr, (Object[])new Object[0]);
        IQueryResult result = repo.query(query, (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)184);
    }

    public void testMatchQueryInjectionInPredicate() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IMatchExpression expr = factory.matchExpression(parser.parse("iquery($0) || iquery($1)"), new Object[]{new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return "true".equals(candidate.getProperty("org.eclipse.equinox.p2.type.category"));
            }
        }, new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return "true".equals(candidate.getProperty("org.eclipse.equinox.p2.type.group"));
            }
        }});
        IQueryResult result = repo.query(QueryUtil.createMatchQuery((IExpression)expr, (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)497);
    }

    public void testRootVariableSerialization() throws Exception {
        ArrayList<MyObject> items = new ArrayList<MyObject>();
        items.add(new MyObject("ian bull", "foo", "true"));
        IExpression item = factory.variable("item");
        IExpression cmp1 = factory.equals(factory.member(item, "id"), factory.indexedParameter(0));
        IExpression everything = factory.variable("everything");
        IExpression lambda = factory.lambda(item, cmp1);
        IContextExpression e3 = factory.contextExpression(factory.select(everything, lambda), new Object[0]);
        IContextExpression contextExpression = factory.contextExpression(parser.parseQuery(e3.toString()), new Object[]{"ian bull"});
        IQuery query = QueryUtil.createQuery(Object.class, (IExpression)contextExpression, (Object[])new Object[0]);
        System.out.println(e3);
        IQueryResult queryResult = query.perform(items.iterator());
        Iterator iterator = queryResult.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public void testMatchQueryInjectionInContext() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/galileoM7");
        IContextExpression expr = factory.contextExpression(parser.parseQuery("select(x | iquery($0, x) || iquery($1, x)).latest()"), new Object[]{new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return "true".equals(candidate.getProperty("org.eclipse.equinox.p2.type.category"));
            }
        }, new MatchQuery<IInstallableUnit>(){

            public boolean isMatch(IInstallableUnit candidate) {
                return "true".equals(candidate.getProperty("org.eclipse.equinox.p2.type.group"));
            }
        }});
        IQueryResult result = repo.query(QueryUtil.createQuery((IExpression)expr, (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        EvaluatorTest.assertEquals((int)EvaluatorTest.queryResultSize(result), (int)497);
    }

    public void testTranslations() {
        File foo_fragment = new File(TestActivator.getTestDataFolder(), "FragmentPublisherTest/foo.fragment");
        File foo = new File(TestActivator.getTestDataFolder(), "FragmentPublisherTest/foo");
        BundlesAction bundlesAction = new BundlesAction(new File[]{foo_fragment});
        PublisherInfo info = new PublisherInfo();
        PublisherResult results = new PublisherResult();
        bundlesAction.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        Collection ius = results.getIUs(null, null);
        EvaluatorTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
        info = new PublisherInfo();
        results = new PublisherResult();
        bundlesAction = new BundlesAction(new File[]{foo});
        bundlesAction.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        bundlesAction = new BundlesAction(new File[]{foo_fragment});
        bundlesAction.perform((IPublisherInfo)info, (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        ius = results.getIUs(null, null);
        EvaluatorTest.assertEquals((String)"2.0", (int)3, (int)ius.size());
        QueryableArray queryableArray = new QueryableArray(ius.toArray(new IInstallableUnit[ius.size()]));
        IQueryResult result = queryableArray.query(QueryUtil.createIUQuery((String)"foo"), null);
        EvaluatorTest.assertEquals((String)"2.1", (int)1, (int)EvaluatorTest.queryResultSize(result));
        IQuery lq = QueryUtil.createMatchQuery((String)"translatedProperties[$0] ~= /German*/", (Object[])new Object[]{new KeyWithLocale("org.eclipse.equinox.p2.name", Locale.GERMAN)});
        Iterator itr = queryableArray.query(lq, (IProgressMonitor)new NullProgressMonitor()).iterator();
        EvaluatorTest.assertTrue((boolean)itr.hasNext());
        EvaluatorTest.assertEquals((String)"2.8", (String)"foo", (String)((IInstallableUnit)itr.next()).getId());
        EvaluatorTest.assertFalse((boolean)itr.hasNext());
    }

    private IMetadataRepository getMDR(String uri) throws Exception {
        URI metadataRepo = EvaluatorTest.getTestData("1.1", uri).toURI();
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)EvaluatorTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        EvaluatorTest.assertNotNull((Object)metadataManager);
        return metadataManager.loadRepository(metadataRepo, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testConsistency() throws Exception {
        IMetadataRepository repo = this.getMDR("/testData/metadataRepo/qltest");
        IQuery query1 = QueryUtil.createIUGroupQuery();
        IQuery query2 = QueryUtil.createQuery((String)"select(iu2 | iu2.requirements.exists(r | r != null) || exists(iu | iu.requirements.exists(r | iu2 ~= r)))", (Object[])new Object[0]);
        IQueryResult rt2 = repo.query(QueryUtil.createPipeQuery((IQuery)query1, (IQuery)query2), null);
        IQueryResult rt = repo.query(query1, null);
        IQueryResult rt1 = rt.query(QueryUtil.createQuery((String)"select(iu2 | iu2.requirements.exists(r | r != null))", (Object[])new Object[0]), null);
        rt = rt.query(QueryUtil.createQuery((String)"select(iu | $0.exists(i | i.requirements.exists(r | iu ~= r)))", (Object[])new Object[]{rt1.toArray(IInstallableUnit.class)}), null);
        Set set = rt.toSet();
        set.addAll(rt1.toSet());
        EvaluatorTest.assertTrue((String)"Query results are inconsistent.", (set.size() == rt2.toSet().size() ? 1 : 0) != 0);
    }

    static class MyObject {
        String id;
        Map<String, String> properties = new HashMap<String, String>();

        public MyObject(String id, String key, String value) {
            this.id = id;
            this.properties.put(key, value);
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

