/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractReconcilerTest;

public class AbstractSharedBundleProductTest
extends AbstractReconcilerTest {
    public static final String PLATFORM_BASE = "platform:/base/";
    protected static String sharedLocationURL = null;

    public AbstractSharedBundleProductTest(String name) {
        super(name);
    }

    public AbstractSharedBundleProductTest(String name, String location) {
        super(name, location);
    }

    private Map<String, BundleInfo> getBootstrapBundles() {
        HashMap<String, BundleInfo> result = new HashMap<String, BundleInfo>();
        String[] bootstrap = new String[]{"org.eclipse.core.contenttype", "org.eclipse.core.expressions", "org.eclipse.core.jobs", "org.eclipse.core.net", "org.eclipse.core.runtime", "org.eclipse.core.runtime.compatibility.registry", "org.eclipse.ecf", "org.eclipse.ecf.filetransfer", "org.eclipse.ecf.identity", "org.eclipse.ecf.provider.filetransfer", "org.eclipse.ecf.provider.filetransfer.ssl", "org.eclipse.ecf.ssl", "org.eclipse.equinox.app", "org.eclipse.equinox.common", "org.eclipse.equinox.ds", "org.eclipse.equinox.frameworkadmin", "org.eclipse.equinox.frameworkadmin.equinox", "org.eclipse.equinox.p2.artifact.repository", "org.eclipse.equinox.p2.core", "org.eclipse.equinox.p2.director", "org.eclipse.equinox.p2.directorywatcher", "org.eclipse.equinox.p2.engine", "org.eclipse.equinox.p2.extensionlocation", "org.eclipse.equinox.p2.garbagecollector", "org.eclipse.equinox.p2.jarprocessor", "org.eclipse.equinox.p2.metadata", "org.eclipse.equinox.p2.metadata.repository", "org.eclipse.equinox.p2.publisher", "org.eclipse.equinox.p2.ql", "org.eclipse.equinox.p2.reconciler.dropins", "org.eclipse.equinox.p2.repository", "org.eclipse.equinox.p2.touchpoint.eclipse", "org.eclipse.equinox.p2.touchpoint.natives", "org.eclipse.equinox.preferences", "org.eclipse.equinox.registry", "org.eclipse.equinox.security", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.equinox.simpleconfigurator.manipulator", "org.eclipse.equinox.util", "org.eclipse.osgi", "org.eclipse.osgi.services", "org.sat4j.core", "org.sat4j.pb"};
        BundleInfo[] infos = null;
        try {
            infos = this.loadBundlesInfo(this.getBundlesInfo());
        }
        catch (IOException e) {
            AbstractSharedBundleProductTest.fail("Exception occurred loading bundles.info file from: " + this.getBundlesInfo().getAbsolutePath(), e);
        }
        HashMap<String, BundleInfo> map = new HashMap<String, BundleInfo>();
        int i = 0;
        while (infos != null && i < infos.length) {
            map.put(infos[i].getSymbolicName(), infos[i]);
            if (infos[i].getSymbolicName().contains("equinox.launcher")) {
                result.put(infos[i].getSymbolicName(), infos[i]);
            }
            ++i;
        }
        i = 0;
        while (i < bootstrap.length) {
            BundleInfo info = (BundleInfo)map.get(bootstrap[i]);
            if (info != null) {
                result.put(info.getSymbolicName(), info);
            }
            ++i;
        }
        return result;
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        File shared = new File(output, "shared");
        shared.mkdirs();
        AbstractSharedBundleProductTest.assertTrue((String)"0.0", (boolean)shared.isDirectory());
        File features = new File(output, "eclipse/features");
        File sharedFeatureLocation = new File(shared, "features");
        AbstractSharedBundleProductTest.move("1.0", features, sharedFeatureLocation);
        File bundles = new File(output, "eclipse/plugins");
        File sharedBundleLocation = new File(shared, "plugins");
        FileFilter filter = pathname -> !pathname.getName().contains("equinox.launcher");
        AbstractSharedBundleProductTest.move("2.0", bundles, sharedBundleLocation, filter);
        Map<String, BundleInfo> infos = this.getBootstrapBundles();
        this.updateBundlesInfo(infos, sharedBundleLocation);
        this.updateConfiguration(infos, shared);
        this.updateConfigIni(infos);
        this.reconcile("5.0");
    }

    private void updateConfigIni(Map<String, BundleInfo> infos) {
        Throwable throwable;
        File location = new File(output, "eclipse/configuration/config.ini");
        Properties ini = new Properties();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(location));){
                ini.load(input);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            AbstractSharedBundleProductTest.fail("Exception while loading config.ini from: " + location.getAbsolutePath(), e);
        }
        BundleInfo framework = infos.get("org.eclipse.osgi");
        AbstractSharedBundleProductTest.assertNotNull((String)"Unable to find framework in list of bootstrap bundles.", (Object)framework);
        ini.put("osgi.framework", framework.getLocation().toString());
        try {
            throwable = null;
            Object var6_11 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(location));){
                ini.store(out, null);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            AbstractSharedBundleProductTest.fail("Exception while saving config.ini to: " + location.getAbsolutePath(), e);
        }
    }

    private void updateConfiguration(Map<String, BundleInfo> infos, File shared) {
        Configuration config = new Configuration();
        config.setTransient(false);
        config.setVersion("3.0");
        Site site = new Site();
        try {
            sharedLocationURL = shared.toURI().toURL().toExternalForm();
            site.setUrl(sharedLocationURL);
        }
        catch (MalformedURLException e) {
            AbstractSharedBundleProductTest.fail("Exception occurred while converting site location to URL: " + shared.getAbsolutePath(), e);
        }
        site.setPolicy("USER-INCLUDE");
        site.setUpdateable(false);
        site.setEnabled(true);
        URI sharedURI = shared.toURI();
        for (BundleInfo info : infos.values()) {
            URI relative = URIUtil.makeRelative((URI)info.getLocation(), (URI)sharedURI);
            site.addPlugin(relative.toString());
        }
        config.add(site);
        site = new Site();
        site.setUrl(PLATFORM_BASE);
        site.setPolicy("USER-EXCLUDE");
        site.setUpdateable(true);
        site.setEnabled(true);
        config.add(site);
        this.saveConfiguration(config);
    }

    public void removeBundlesFromConfiguration(Configuration config, String[] locations) {
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            this.removeBundleFromConfiguration(config, location);
            ++n2;
        }
    }

    protected Site getSharedSite(Configuration config) {
        for (Site site : config.getSites()) {
            if (sharedLocationURL == null || !sharedLocationURL.equals(site.getUrl())) continue;
            return site;
        }
        return null;
    }

    public boolean removeBundleFromConfiguration(Configuration config, String location) {
        Site shared = this.getSharedSite(config);
        AbstractSharedBundleProductTest.assertNotNull((String)"Unable to determine shared site from configuration.", (Object)shared);
        boolean removed = shared.removePlugin(location);
        if (removed) {
            return true;
        }
        URI relative = null;
        try {
            relative = URIUtil.makeRelative((URI)new URI(location), (URI)new URI(sharedLocationURL));
        }
        catch (URISyntaxException e) {
            AbstractSharedBundleProductTest.fail("Exception while converting location to URI.", e);
        }
        return shared.removePlugin(relative.toString());
    }

    public void addBundlesToConfigurations(Configuration config, String[] locations) {
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            this.addBundleToConfiguration(config, location);
            ++n2;
        }
    }

    public void addBundleToConfiguration(Configuration config, String location) {
        Site shared = this.getSharedSite(config);
        AbstractSharedBundleProductTest.assertNotNull((String)"Unable to determine shared site from configuration.", (Object)shared);
        URI relative = null;
        try {
            relative = URIUtil.makeRelative((URI)new URI(location), (URI)new URI(sharedLocationURL));
        }
        catch (URISyntaxException e) {
            AbstractSharedBundleProductTest.fail("Exception while converting location to URI.", e);
        }
        shared.addPlugin(relative.toString());
    }

    protected File getPlatformXMLLocation() {
        return new File(output, "eclipse/configuration/org.eclipse.update/platform.xml");
    }

    public void saveConfiguration(Configuration config) {
        File configLocation = this.getPlatformXMLLocation();
        try {
            config.save(configLocation, null);
        }
        catch (ProvisionException e) {
            AbstractSharedBundleProductTest.fail("Exception occurred while saving configuration: " + configLocation.getAbsolutePath(), e);
        }
    }

    public Configuration loadConfiguration() {
        File configLocation = this.getPlatformXMLLocation();
        try {
            return Configuration.load((File)configLocation, null);
        }
        catch (ProvisionException e) {
            AbstractSharedBundleProductTest.fail("Exception loading configuration.", e);
            return null;
        }
    }

    private void updateBundlesInfo(Map<String, BundleInfo> infos, File sharedBundleLocation) {
        for (BundleInfo info : infos.values()) {
            if (info.getSymbolicName().contains("equinox.launcher")) continue;
            File location = new File(sharedBundleLocation, new Path(info.getLocation().toString()).lastSegment());
            AbstractSharedBundleProductTest.assertTrue((String)("3.1." + location.getAbsolutePath()), (boolean)location.exists());
            info.setLocation(location.toURI());
        }
        try {
            this.saveBundlesInfo(infos.values().toArray(new BundleInfo[infos.size()]), this.getBundlesInfo());
        }
        catch (IOException e) {
            AbstractSharedBundleProductTest.fail("Exception occurred while saving bundles.info to: " + this.getBundlesInfo().getAbsolutePath(), e);
        }
    }
}

