/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChecksumHelperTest {
    @Parameterized.Parameter(value=0)
    public String property;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({"artifact.checksum"}, {"download.checksum"});
    }

    @Test
    public void testGetChecksums() {
        String checksumId = "checksumAlgo";
        String checksumValue = "value";
        ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("", "", (Version)new OSGiVersion(1, 1, 1, (Comparable)((Object)""))));
        descriptor.setProperty(this.property.concat(".").concat(checksumId), checksumValue);
        descriptor.setProperty("download.size", "1234");
        HashMap<String, String> expectedChecksums = new HashMap<String, String>();
        expectedChecksums.put(checksumId, checksumValue);
        Map checksums = ChecksumHelper.getChecksums((IArtifactDescriptor)descriptor, (String)this.property);
        Assert.assertEquals(expectedChecksums, (Object)checksums);
    }
}

