/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.net.ConnectException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryTransport;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;

public class FileInfoReaderTest
extends AbstractTestServerClientCase {
    public void testUnknownHost() throws Exception {
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI("http://bogus.nowhere/nothing.xml");
        IStatus status = null;
        try {
            transport.getLastModified(toDownload, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        FileInfoReaderTest.assertEquals((String)"Should be an error", (int)status.getSeverity(), (int)4);
        FileInfoReaderTest.assertTrue((String)"Should begin with 'Unknown Host'", (boolean)status.getMessage().startsWith("Unknown Host"));
    }

    public void testBadPort() throws Exception {
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI("http://localhost:1/nothing.xml");
        IStatus status = null;
        try {
            transport.getLastModified(toDownload, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        FileInfoReaderTest.assertEquals((String)"Should be an error", (int)status.getSeverity(), (int)4);
        FileInfoReaderTest.assertTrue((String)"Should be a connect exception", (boolean)(status.getException() instanceof ConnectException));
        FileInfoReaderTest.assertTrue((String)"Should begin with 'Connection refused'", (boolean)status.getException().getMessage().startsWith("Connection refused"));
    }

    public void testRedirect() throws Exception {
        this.setAladdinLoginService();
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI(String.valueOf(this.getBaseURL()) + "/redirect/101/public/index.html");
        boolean caught = false;
        try {
            transport.getLastModified(toDownload, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            caught = true;
        }
        catch (Throwable t) {
            FileInfoReaderTest.failNotEquals((String)"Wrong exception on 'redirected too many times'", AuthenticationFailedException.class, t.getClass());
            t.printStackTrace();
        }
        FileInfoReaderTest.assertTrue((String)"Should have caught AuthenticationFailedException", (boolean)caught);
    }
}

