/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactRepositoryFactory;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.MetadataRepositoryFactory;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class RepositoryExtensionPointTest
extends AbstractProvisioningTest {
    static URI repositoryKey = URI.create("testregistry:repo");
    static IMetadataRepository metadataRepositoryInstance = new TestMetadataRepository(RepositoryExtensionPointTest.getAgent(), new IInstallableUnit[0]);
    static IArtifactRepository artifactRepositoryInstance = new TestArtifactRepository(RepositoryExtensionPointTest.getAgent(), repositoryKey);

    public void testLoadMetadataRepositoryFromURIWithCustomScheme() throws Exception {
        IMetadataRepository repo = this.loadMetadataRepository(repositoryKey);
        Assert.assertThat((Object)repo, (Matcher)CoreMatchers.sameInstance((Object)metadataRepositoryInstance));
    }

    public void testLoadArtifactRepositoryFromURIWithCustomScheme() throws Exception {
        IArtifactRepository repo = this.loadArtifactRepository(repositoryKey);
        Assert.assertThat((Object)repo, (Matcher)CoreMatchers.sameInstance((Object)artifactRepositoryInstance));
    }

    public static class TestArtifactRepositoryRegistry
    extends ArtifactRepositoryFactory {
        public IArtifactRepository create(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
            int errorCode = 0;
            Status status = new Status(4, "org.eclipse.equinox.p2.test", errorCode, "Creating repositories of type " + type + " is not supported", null);
            throw new ProvisionException((IStatus)status);
        }

        public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) {
            if (repositoryKey.equals(location)) {
                return artifactRepositoryInstance;
            }
            return null;
        }
    }

    public static class TestMetadataRepositoryRegistry
    extends MetadataRepositoryFactory {
        public IMetadataRepository create(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
            int errorCode = 0;
            Status status = new Status(4, "org.eclipse.equinox.p2.test", errorCode, "Creating repositories of type " + type + " is not supported", null);
            throw new ProvisionException((IStatus)status);
        }

        public IMetadataRepository load(URI location, int flags, IProgressMonitor monitor) {
            if (repositoryKey.equals(location)) {
                return metadataRepositoryInstance;
            }
            return null;
        }
    }
}

