/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.cert.Certificate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryTransport;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.tests.metadata.repository.AllServerTests;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;

public class TimeoutTest
extends AbstractTestServerClientCase {
    private static final int MODIFIED = 1;
    private static final int DOWNLOAD = 2;
    private static final int STREAM = 3;
    protected String authTestFailMessage;

    @Override
    public void tearDown() throws Exception {
        AllServerTests.setServiceUI(null);
        super.tearDown();
    }

    public void doTimeout(int type) throws Exception {
        System.out.print("Note that test takes at least 120 seconds before timing out\n");
        AllServerTests.setServiceUI(new AladdinNotSavedService());
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI(String.valueOf(this.getBaseURL()) + "/timeout/whatever.txt");
        long startTime = System.currentTimeMillis();
        boolean caught = false;
        try {
            switch (type) {
                case 2: {
                    IStatus status = transport.download(toDownload, (OutputStream)new ByteArrayOutputStream(), null);
                    this.assertSocketTimeout(status, null);
                    caught = true;
                    break;
                }
                case 1: {
                    transport.getLastModified(toDownload, null);
                    break;
                }
                case 3: {
                    transport.stream(toDownload, null);
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            TimeoutTest.fail((String)"The getLastModified was canceled - the UI auth service is probably not running");
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            this.assertSocketTimeout(status, (Exception)((Object)e));
            caught = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        System.out.print("The timeout took:" + Long.valueOf((endTime - startTime) / 1000L).toString() + "\n");
        TimeoutTest.assertTrue((String)"timeout should have been caught", (boolean)caught);
    }

    private void assertSocketTimeout(IStatus status, Exception e) {
        String msg;
        Throwable ex = status.getException();
        String string = msg = e == null ? "" : e.getMessage();
        if (ex instanceof CoreException) {
            msg = ((CoreException)ex).getStatus().getMessage();
        }
        System.out.print(String.format("%s e-message: [%s], detail:[%s]\n", TimeoutTest.provisionCodeToText(status.getCode()), msg, ex != null ? ex.getMessage() : "<no detailed message>"));
        TimeoutTest.assertEquals((String)"Socket timeout exception should be found as detail", ex.getClass(), SocketTimeoutException.class);
    }

    public void testInfoTimeout() throws Exception {
        this.doTimeout(1);
    }

    public void testInfoTimeoutCancelation() throws Exception {
        this.doTimeoutCancelation(1);
    }

    public void testDownloadTimeout() throws Exception {
        this.doTimeout(2);
    }

    public void testDownloadTimeoutCancelation() throws Exception {
        this.doTimeoutCancelation(2);
    }

    public void testStreamTimeout() throws Exception {
        this.doTimeout(3);
    }

    public void testStreamTimeoutCancelation() throws Exception {
        this.doTimeoutCancelation(3);
    }

    public void doTimeoutCancelation(int type) throws Exception {
        System.out.print("Note that test takes at least 10 seconds before timing out (and >120 if it fails)\n");
        AllServerTests.setServiceUI(new AladdinNotSavedService());
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI(String.valueOf(this.getBaseURL()) + "/timeout/whatever.txt");
        NullProgressMonitor monitor = new NullProgressMonitor();
        MonitorCancelation cancelHandler = new MonitorCancelation((IProgressMonitor)monitor, 10000L);
        Thread proc = new Thread((Runnable)cancelHandler, "cancelHandler");
        proc.start();
        boolean caught = false;
        long startTime = System.currentTimeMillis();
        try {
            switch (type) {
                case 2: {
                    transport.download(toDownload, (OutputStream)new ByteArrayOutputStream(), (IProgressMonitor)monitor);
                    break;
                }
                case 1: {
                    transport.getLastModified(toDownload, (IProgressMonitor)monitor);
                    break;
                }
                case 3: {
                    transport.stream(toDownload, (IProgressMonitor)monitor);
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            caught = true;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            Throwable ex = status.getException();
            String msg = e.getMessage();
            if (ex instanceof CoreException) {
                msg = ((CoreException)ex).getStatus().getMessage();
            }
            System.out.print(String.format("%s e-message: [%s], detail:[%s]\n", TimeoutTest.provisionCodeToText(status.getCode()), msg, ex != null ? ex.getMessage() : "<no detailed message>"));
            TimeoutTest.assertEquals((String)"Socket exception (socket closed) should be found as detail", ex.getClass(), SocketException.class);
            TimeoutTest.assertEquals((String)"Exception message from SocketException", (String)"Socket closed", (String)ex.getMessage());
            caught = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        TimeoutTest.assertTrue((String)"The timeout should have been canceled", (boolean)caught);
        TimeoutTest.assertTrue((String)"The cancel should happen before the timeout", (endTime - startTime < 50000L ? 1 : 0) != 0);
    }

    private static String provisionCodeToText(int code) {
        String msg = "REPOSITORY_";
        switch (code) {
            case 1001: {
                return String.valueOf(msg) + "EXISTS";
            }
            case 1007: {
                return String.valueOf(msg) + "FAILED_AUTHENTICATION";
            }
            case 1002: {
                return String.valueOf(msg) + "FAILED_READ";
            }
            case 1003: {
                return String.valueOf(msg) + "FAILED_WRITE";
            }
            case 1006: {
                return String.valueOf(msg) + "INVALID_LOCATION";
            }
            case 1000: {
                return String.valueOf(msg) + "NOT_FOUND";
            }
            case 1004: {
                return String.valueOf(msg) + "READ_ONLY";
            }
            case 1005: {
                return String.valueOf(msg) + "UNKNOWN_TYPE";
            }
        }
        return String.valueOf(msg) + String.format("<unrecognized error code: %d >", code);
    }

    public class AladdinNotSavedService
    extends UIServices {
        public int counter = 0;

        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            ++this.counter;
            return new UIServices.AuthenticationInfo("Aladdin", "open sesame", false);
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            ++this.counter;
            TimeoutTest.assertEquals((String)"Aladdin", (String)previousInfo.getUserName());
            TimeoutTest.assertEquals((String)"open sesame", (String)previousInfo.getPassword());
            TimeoutTest.assertEquals((boolean)false, (boolean)previousInfo.saveResult());
            return previousInfo;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            return new UIServices.TrustInfo(null, false, true);
        }
    }

    public static class MonitorCancelation
    implements Runnable {
        private IProgressMonitor theMonitor;
        private long theDelay;

        MonitorCancelation(IProgressMonitor monitor, long delay) {
            this.theMonitor = monitor;
            this.theDelay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.theDelay);
            }
            catch (InterruptedException interruptedException) {}
            System.out.print("TimeoutTest: Cancelling monitor\n");
            this.theMonitor.setCanceled(true);
        }
    }
}

