/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.io.File;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.PreviousConfigurationFinder;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PreviousConfigurationFinderTest
extends AbstractProvisioningTest {
    private PreviousConfigurationFinder.ConfigurationDescriptor referenceConfiguration;

    @Override
    protected void setUp() throws Exception {
        this.referenceConfiguration = new PreviousConfigurationFinder.ConfigurationDescriptor("org.eclipse.platform", new PreviousConfigurationFinder.Identifier(4, 3, 0), "12345678", "win32_win32_x86", null);
    }

    public void testUpdateToNewBuildInPlace_sameProduct() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testUpdateToNewBuildInPlace/sameProduct");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromInstallHashDir(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(4, 2, 1), (Object)match.getVersion());
    }

    public void testUpdateToNewBuildInPlace_mixedProducts() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testUpdateToNewBuildInPlace/mixedProducts");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromInstallHashDir(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(4, 2, 0), (Object)match.getVersion());
    }

    public void testUpdateToNewBuildInPlace_differentProduct() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testUpdateToNewBuildInPlace/differentProduct");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromInstallHashDir(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.epp.jee", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(1, 5, 1), (Object)match.getVersion());
    }

    public void testUpdateToNewBuildInPlace_noMatch() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testUpdateToNewBuildInPlace/noMatch");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromInstallHashDir(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertNull((Object)match);
    }

    public void testNewBuildInDifferentFolder_sameProduct() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testNewBuildInDifferentFolder/sameProduct");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(4, 2, 1), (Object)match.getVersion());
    }

    public void testNewBuildInDifferentFolder_sameProductWithSameVersion() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testNewBuildInDifferentFolder/sameProductWithSameVersion");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(4, 3, 0), (Object)match.getVersion());
    }

    public void testNewBuildInDifferentFolder_noMatch() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testNewBuildInDifferentFolder/noMatch");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertNull((Object)match);
    }

    public void testNewBuildInDifferentFolder_mixedProducts() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testNewBuildInDifferentFolder/mixedProducts");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(4, 2, 0), (Object)match.getVersion());
    }

    public void testNewBuildInDifferentFolder_differentConfigurations() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testNewBuildInDifferentFolder/differentConfigurations");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(4, 1, 0), (Object)match.getVersion());
    }

    public void testLegacyFormat() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testLegacyFormat");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertEquals((String)"org.eclipse.platform", (String)match.getProductId());
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(3, 8, 1), (Object)match.getVersion());
        PreviousConfigurationFinderTest.assertNull((Object)match.getPlatformConfig());
    }

    public void testNoMatchFromSucceedingVersion() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testSuccedingVersion/noMatch");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertNull((Object)match);
    }

    public void testMatchFromPreceedingVersionWithDifferentPaltform() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testSuccedingVersion/matchFromSuccedingAndPreccedingWithDifferentPlatfrom");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertNotNull((Object)match);
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(3, 8, 0), (Object)match.getVersion());
        PreviousConfigurationFinderTest.assertEquals((String)"linux-gtk-x86_64", (String)match.getPlatformConfig());
    }

    public void testMatchFromPreceedingVersionWithNullPaltform() throws Exception {
        File configFolder = PreviousConfigurationFinderTest.getTestData("sameProduct", "testData/previousConfigurationFinder/testSuccedingVersion/matchFromSuccedingAndPreccedingWithNullPlatfrom");
        List configs = new PreviousConfigurationFinder(configFolder).readPreviousConfigurations(configFolder);
        PreviousConfigurationFinder.ConfigurationDescriptor match = new PreviousConfigurationFinder(configFolder).findMostRelevantConfigurationFromProductId(configs, this.referenceConfiguration);
        PreviousConfigurationFinderTest.assertNotNull((Object)match);
        PreviousConfigurationFinderTest.assertEquals((Object)new PreviousConfigurationFinder.Identifier(3, 8, 0), (Object)match.getVersion());
        PreviousConfigurationFinderTest.assertNull((Object)match.getPlatformConfig());
    }
}

