/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SharedProfilePreferencesTest
extends AbstractProvisioningTest {
    @Override
    protected void setUp() throws Exception {
        Bundle p2Core = Platform.getBundle((String)"org.eclipse.equinox.p2.core");
        p2Core.stop();
        File baseInstallToCopy = SharedProfilePreferencesTest.getTestData("baseInstall", "testData/sharedPrefs/test1/baseInstall");
        File baseInstall = this.getTempFolder();
        File baseInstallToCopyTo = new File(baseInstall, "p2/org.eclipse.equinox.p2.engine/profileRegistry");
        baseInstallToCopy.mkdirs();
        SharedProfilePreferencesTest.copy("copy base install", baseInstallToCopy, baseInstallToCopyTo);
        File userHomeToCopy = SharedProfilePreferencesTest.getTestData("useHome", "testData/sharedPrefs/test1/userHome");
        File userHome = this.getTempFolder();
        File userHomeToCopyTo = new File(userHome, "p2/org.eclipse.equinox.p2.engine/");
        userHomeToCopyTo.mkdirs();
        SharedProfilePreferencesTest.copy("copy user home data", userHomeToCopy, userHomeToCopyTo);
        System.setProperty("osgi.sharedConfiguration.area", new File(baseInstall, "configuration").toURI().toString());
        System.setProperty("osgi.configuration.area", String.valueOf(new File(userHome, "configuration").toURI().toString()) + '/');
        System.setProperty("eclipse.p2.profile", "epp.package.java");
        System.setProperty("eclipse.p2.data.area", "@config.dir/../p2");
        IPreferencesService prefService = (IPreferencesService)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IPreferencesService.class);
        prefService.getRootNode().node("/profile/").removeNode();
        p2Core.start();
    }

    public void testCountReposInSharedInstallPreferences() {
        IPreferencesService prefService = (IPreferencesService)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IPreferencesService.class);
        SharedProfilePreferencesTest.assertNotNull((Object)prefService);
        try {
            URI defaultLocation = SharedProfilePreferencesTest.adjustTrailingSlash(URIUtil.makeAbsolute((URI)URIUtil.fromString((String)(String.valueOf(TestActivator.getContext().getProperty("osgi.configuration.area")) + "/../p2/")), (URI)new URI(".")), true);
            String locationString = EncodingUtils.encodeSlashes((String)defaultLocation.toString());
            Preferences node = prefService.getRootNode().node("/profile/shared/" + locationString + "/_SELF_/org.eclipse.equinox.p2.metadata.repository/repositories");
            String[] children = node.childrenNames();
            SharedProfilePreferencesTest.assertEquals((int)3, (int)children.length);
        }
        catch (IllegalArgumentException e) {
            SharedProfilePreferencesTest.fail("Exception", e);
        }
        catch (URISyntaxException e) {
            SharedProfilePreferencesTest.fail("Exception", e);
        }
        catch (BackingStoreException e) {
            SharedProfilePreferencesTest.fail("Exception", e);
        }
    }

    private static URI adjustTrailingSlash(URI url, boolean trailingSlash) throws URISyntaxException {
        String file = url.toString();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URI(file);
    }

    public void testCountRepoInSharedInstallThroughRepoManagerAPI() {
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)SharedProfilePreferencesTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        URI[] repos = repoMgr.getKnownRepositories(0);
        SharedProfilePreferencesTest.assertEquals((int)3, (int)repos.length);
    }
}

