/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.tests.sharedinstall.AbstractSharedInstallTest;
import org.eclipse.equinox.p2.tests.simpleconfigurator.SimpleConfiguratorTestExtended;

public class SimpleConfiguratorTestExtendedConfigured
extends SimpleConfiguratorTestExtended {
    private File parentFolder;
    private File ext1Info;
    private File ext1Parent;
    private File ext3Info;
    private File ext3Parent;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.parentFolder = new File(this.getTempFolder(), "extension");
        this.ext1Parent = new File(this.parentFolder, "ext1");
        this.ext1Parent.mkdirs();
        this.ext1Info = new File(this.ext1Parent, "ext1.info");
        this.ext1Info.createNewFile();
        this.ext3Parent = new File(this.parentFolder, "ext3");
        this.ext3Parent.mkdirs();
        this.ext3Info = new File(this.ext3Parent, "ext3.info");
        this.ext3Info.createNewFile();
        this.ext1Info.setLastModified(System.currentTimeMillis() + 1000L);
        AbstractSharedInstallTest.setReadOnly(this.ext1Parent, true);
        AbstractSharedInstallTest.reallyReadOnly(this.ext1Parent);
        this.ext3Info.setLastModified(System.currentTimeMillis() + 1000L);
    }

    @Override
    protected void tearDown() throws Exception {
        Activator.EXTENSIONS = null;
        AbstractSharedInstallTest.removeReallyReadOnly(this.ext1Parent);
        AbstractSharedInstallTest.setReadOnly(this.ext1Parent, false);
        super.tearDown();
    }

    public void testWriteableExtension() throws FileNotFoundException, IOException, URISyntaxException {
        Activator.EXTENSIONS = this.parentFolder.toString();
        ArrayList infoFiles = SimpleConfiguratorUtils.getInfoFiles();
        SimpleConfiguratorTestExtendedConfigured.assertEquals((String)"only read-only info file should be considered", (int)1, (int)infoFiles.size());
        SimpleConfiguratorTestExtendedConfigured.assertEquals((String)this.ext1Info.getName(), (String)((File)infoFiles.get(0)).getName());
    }

    public void testExtensionAdded() throws IOException {
        this.storeTimestamp(new File(this.masterConfguration, this.relativeURL.getFile()).lastModified());
        SimpleConfiguratorTestExtendedConfigured.assertEquals((Object)this.sharedConfiguration[0], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(false);
        Activator.EXTENSIONS = this.parentFolder.toString();
        SimpleConfiguratorTestExtendedConfigured.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
    }

    public void testExtensionRemoved() throws IOException {
        Activator.EXTENSIONS = this.parentFolder.toString();
        this.storeTimestamp(this.ext1Info.lastModified());
        SimpleConfiguratorTestExtendedConfigured.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
        Activator.EXTENSIONS = null;
        SimpleConfiguratorTestExtendedConfigured.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
    }

    public void testExtensionModified() throws IOException {
        Activator.EXTENSIONS = this.parentFolder.toString();
        this.storeTimestamp(this.ext1Info.lastModified());
        SimpleConfiguratorTestExtendedConfigured.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
        File ext2Dir = new File(this.parentFolder, "ext2");
        ext2Dir.mkdirs();
        File file = new File(ext2Dir, "ext2.info");
        file.createNewFile();
        file.setLastModified(this.parentFolder.lastModified() + 3000L);
        SimpleConfiguratorTestExtendedConfigured.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
    }
}

