/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.AddProgramArgumentAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class AddProgramArgumentActionTest
extends AbstractProvisioningTest {
    public AddProgramArgumentActionTest(String name) {
        super(name);
    }

    public AddProgramArgumentActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", AddProgramArgumentActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, AddProgramArgumentActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        AddProgramArgumentActionTest.assertNotNull((Object)manipulator);
        String programArg = "-test";
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(programArg));
        parameters.put("programArg", programArg);
        parameters = Collections.unmodifiableMap(parameters);
        AddProgramArgumentAction action = new AddProgramArgumentAction();
        action.execute(parameters);
        AddProgramArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(programArg));
        action.undo(parameters);
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(programArg));
    }

    public void testExecuteUndoWithArtifact() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)AddProgramArgumentActionTest.getAgent(), (IProfile)profile);
        File osgiSource = AddProgramArgumentActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        AddProgramArgumentActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        AddProgramArgumentActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", AddProgramArgumentActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        AddProgramArgumentActionTest.assertNotNull((Object)manipulator);
        String programArg = "-somekey";
        HashMap<String, String> keyParameters = new HashMap<String, String>(parameters);
        keyParameters.put("programArg", programArg);
        programArg = "@artifact";
        String resolvedArtifact = osgiTarget.getAbsolutePath();
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        parameters.put("programArg", programArg);
        parameters = Collections.unmodifiableMap(parameters);
        AddProgramArgumentAction artifactAction = new AddProgramArgumentAction();
        AddProgramArgumentAction keyAction = new AddProgramArgumentAction();
        keyAction.execute(keyParameters);
        artifactAction.execute(parameters);
        AddProgramArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        artifactAction.undo(parameters);
        keyAction.undo(keyParameters);
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
    }

    public void testExecuteUndoWithArtifactByProgramArgValue() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)AddProgramArgumentActionTest.getAgent(), (IProfile)profile);
        File osgiSource = AddProgramArgumentActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        AddProgramArgumentActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        AddProgramArgumentActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", AddProgramArgumentActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        AddProgramArgumentActionTest.assertNotNull((Object)manipulator);
        String programArg = "-somekey";
        String programArgValue = "@artifact";
        HashMap<String, String> keyParameters = new HashMap<String, String>(parameters);
        keyParameters.put("programArg", programArg);
        keyParameters.put("programArgValue", programArgValue);
        programArg = "@artifact";
        programArgValue = "@ignore";
        String resolvedArtifact = osgiTarget.getAbsolutePath();
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        parameters.put("programArg", programArg);
        parameters.put("programArgValue", programArgValue);
        parameters = Collections.unmodifiableMap(parameters);
        AddProgramArgumentAction artifactAction = new AddProgramArgumentAction();
        AddProgramArgumentAction keyAction = new AddProgramArgumentAction();
        keyAction.execute(keyParameters);
        artifactAction.execute(parameters);
        AddProgramArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        AddProgramArgumentActionTest.assertEquals((int)2, (int)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).size());
        artifactAction.undo(parameters);
        keyAction.undo(keyParameters);
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
    }

    public void testExecuteUndoWithArtifactLocation() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)AddProgramArgumentActionTest.getAgent(), (IProfile)profile);
        File osgiSource = AddProgramArgumentActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        AddProgramArgumentActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        AddProgramArgumentActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", AddProgramArgumentActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        AddProgramArgumentActionTest.assertNotNull((Object)manipulator);
        String programArg = "-somekey";
        HashMap<String, String> keyParameters = new HashMap<String, String>(parameters);
        keyParameters.put("programArg", programArg);
        programArg = (String)parameters.get("artifact.location");
        String resolvedArtifact = osgiTarget.getAbsolutePath();
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        parameters.put("programArg", programArg);
        parameters = Collections.unmodifiableMap(parameters);
        AddProgramArgumentAction artifactAction = new AddProgramArgumentAction();
        AddProgramArgumentAction keyAction = new AddProgramArgumentAction();
        keyAction.execute(keyParameters);
        artifactAction.execute(parameters);
        AddProgramArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        artifactAction.undo(parameters);
        keyAction.undo(keyParameters);
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
    }

    public void testExecuteUndoWithArtifactLocationByProgramArgValue() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)AddProgramArgumentActionTest.getAgent(), (IProfile)profile);
        File osgiSource = AddProgramArgumentActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        AddProgramArgumentActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        AddProgramArgumentActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", AddProgramArgumentActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        AddProgramArgumentActionTest.assertNotNull((Object)manipulator);
        String programArg = "-somekey";
        String programArgValue = (String)parameters.get("artifact.location");
        HashMap<String, String> keyParameters = new HashMap<String, String>(parameters);
        keyParameters.put("programArg", programArg);
        keyParameters.put("programArgValue", programArgValue);
        programArg = "@artifact";
        programArgValue = "@ignore";
        String resolvedArtifact = osgiTarget.getAbsolutePath();
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        parameters.put("programArg", programArg);
        parameters.put("programArgValue", programArgValue);
        parameters = Collections.unmodifiableMap(parameters);
        AddProgramArgumentAction artifactAction = new AddProgramArgumentAction();
        AddProgramArgumentAction keyAction = new AddProgramArgumentAction();
        keyAction.execute(keyParameters);
        artifactAction.execute(parameters);
        AddProgramArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        AddProgramArgumentActionTest.assertEquals((int)2, (int)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).size());
        artifactAction.undo(parameters);
        keyAction.undo(keyParameters);
        AddProgramArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
    }
}

