/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AgentFromInstall;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AgentFromInstallTests
extends AbstractProvisioningTest {
    public void testNormalEclipseFromInstallFolder() {
        File installFolder = AgentFromInstallTests.getTestData("normalEclipse", "testData/configAreaToAgent/normalEclipse");
        IProvisioningAgent agent = AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AgentFromInstallTests.getAgentProvider(), (File)installFolder, null, null);
        AgentFromInstallTests.assertNotNull((Object)agent);
        IProfile profile = ((IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)).getProfile("_SELF_");
        AgentFromInstallTests.assertNotNull((Object)profile);
        AgentFromInstallTests.assertEquals((String)"SDKProfile", (String)profile.getProfileId());
    }

    public void testNormalEclipseFromConfiguration() {
        File configurationFolder = AgentFromInstallTests.getTestData("normalEclipse", "testData/configAreaToAgent/normalEclipse/configuration");
        IProvisioningAgent agent = AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AgentFromInstallTests.getAgentProvider(), null, (File)configurationFolder, null);
        AgentFromInstallTests.assertNotNull((Object)agent);
        IProfile profile = ((IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)).getProfile("_SELF_");
        AgentFromInstallTests.assertNotNull((Object)profile);
        AgentFromInstallTests.assertEquals((String)"SDKProfile", (String)profile.getProfileId());
    }

    public void testSharedInstallWithoutBase() {
        File configurationFolder = AgentFromInstallTests.getTestData("sharedWithoutBaseAvailable", "testData/configAreaToAgent/sharedWithoutBaseAvailable");
        IProvisioningAgent agent = AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AgentFromInstallTests.getAgentProvider(), null, (File)configurationFolder, null);
        AgentFromInstallTests.assertNotNull((Object)agent);
        IProfile profile = ((IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)).getProfile("_SELF_");
        AgentFromInstallTests.assertNotNull((Object)profile);
        AgentFromInstallTests.assertEquals((String)"SDKProfile", (String)profile.getProfileId());
    }

    public void testMissingInstallFolder() {
        IProvisioningAgent agent = AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AgentFromInstallTests.getAgentProvider(), (File)new File("someRandomFile_that_does_not_exists"), null, null);
        AgentFromInstallTests.assertNull((Object)agent);
    }

    public void testTooManyProfiles() {
        File configurationFolder = AgentFromInstallTests.getTestData("sharedWithoutBaseAvailable", "testData/configAreaToAgent/tooManyProfiles");
        IProvisioningAgent agent = AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AgentFromInstallTests.getAgentProvider(), null, (File)configurationFolder, null);
        AgentFromInstallTests.assertNull((Object)agent);
    }

    public void testTooManyProfilesWithProfileId() {
        File configurationFolder = AgentFromInstallTests.getTestData("sharedWithoutBaseAvailable", "testData/configAreaToAgent/tooManyProfiles");
        IProvisioningAgent agent = AgentFromInstall.createAgentFrom((IProvisioningAgentProvider)AgentFromInstallTests.getAgentProvider(), null, (File)configurationFolder, (String)"OtherProfile");
        AgentFromInstallTests.assertNotNull((Object)agent);
    }
}

