/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.ChmodAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class ChmodActionTest
extends AbstractProvisioningTest {
    public ChmodActionTest(String name) {
        super(name);
    }

    public ChmodActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndo", profileProperties);
        File zipSource = ChmodActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        ChmodActionTest.copy("2.0", zipSource, zipTarget);
        File subDir = new File(installFolder, "subfolder");
        subDir.mkdir();
        File zipTarget2 = new File(subDir, "a.zip");
        ChmodActionTest.copy("3.0", zipSource, zipTarget2);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", ChmodActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "testExecuteUndo", parameters);
        parameters.put("targetDir", installFolder.getAbsolutePath());
        parameters.put("targetFile", "a.zip");
        parameters.put("permissions", "+x");
        Map xparameters = Collections.unmodifiableMap(parameters);
        ChmodAction action = new ChmodAction();
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R");
        parameters.put("targetFile", "subfolder");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R -H");
        parameters.put("targetFile", "subfolder");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("targetFile", "JimmyHoffa");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        IStatus result = action.execute(xparameters);
        ChmodActionTest.assertFalse((String)"Missing file should result in error", (boolean)result.isOK());
        action.undo(xparameters);
    }

    public void testExecuteUndoWithArtifact() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)ChmodActionTest.getAgent(), (IProfile)profile);
        File dirBundleSource = ChmodActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/directoryBased_1.0.0");
        File targetPlugins = new File(installFolder, "plugins");
        ChmodActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File dirBundleTarget = new File(targetPlugins, "directoryBased_1.0.0");
        ChmodActionTest.copy("2.0", dirBundleSource, dirBundleTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)dirBundleTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)dirBundleTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, dirBundleTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", ChmodActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("targetDir", "@artifact");
        parameters.put("targetFile", "plugin.xml");
        parameters.put("permissions", "+x");
        Map xparameters = Collections.unmodifiableMap(parameters);
        ChmodAction action = new ChmodAction();
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R");
        parameters.put("targetDir", "@artifact");
        parameters.put("targetFile", "..");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R -H");
        parameters.put("targetDir", "@artifact");
        parameters.put("targetFile", "..");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("targetDir", "@artifact");
        parameters.put("targetFile", "JimmyHoffa");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        IStatus result = action.execute(xparameters);
        ChmodActionTest.assertFalse((String)"Missing file should result in error", (boolean)result.isOK());
        action.undo(xparameters);
    }

    public void testExecuteUndoWithArtifactLocation() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)ChmodActionTest.getAgent(), (IProfile)profile);
        File dirBundleSource = ChmodActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/directoryBased_1.0.0");
        File targetPlugins = new File(installFolder, "plugins");
        ChmodActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File dirBundleTarget = new File(targetPlugins, "directoryBased_1.0.0");
        ChmodActionTest.copy("2.0", dirBundleSource, dirBundleTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)dirBundleTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)dirBundleTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, dirBundleTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", ChmodActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("targetDir", parameters.get("artifact.location"));
        parameters.put("targetFile", "plugin.xml");
        parameters.put("permissions", "+x");
        Map xparameters = Collections.unmodifiableMap(parameters);
        ChmodAction action = new ChmodAction();
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R");
        parameters.put("targetDir", parameters.get("artifact.location"));
        parameters.put("targetFile", "..");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R -H");
        parameters.put("targetDir", parameters.get("artifact.location"));
        parameters.put("targetFile", "..");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("targetDir", parameters.get("artifact.location"));
        parameters.put("targetFile", "JimmyHoffa");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        IStatus result = action.execute(xparameters);
        ChmodActionTest.assertFalse((String)"Missing file should result in error", (boolean)result.isOK());
        action.undo(xparameters);
    }
}

