/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.CollectAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class CollectActionTest
extends AbstractProvisioningTest {
    public CollectActionTest(String name) {
        super(name);
    }

    public CollectActionTest() {
        super("");
    }

    public void testExecuteUndo() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        Util.getBundlePoolRepository((IProvisioningAgent)CollectActionTest.getAgent(), (IProfile)profile);
        File osgiSource = CollectActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        CollectActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        CollectActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", CollectActionTest.getAgent());
        parameters.put("profile", profile);
        parameters.put("artifactRequests", new ArrayList());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters = Collections.unmodifiableMap(parameters);
        List requests = (List)parameters.get("artifactRequests");
        CollectActionTest.assertFalse((boolean)this.hasRequest(requests, key));
        CollectAction action = new CollectAction();
        action.execute(parameters);
        CollectActionTest.assertTrue((boolean)this.hasRequest(requests, key));
        action.undo(parameters);
        CollectActionTest.assertTrue((boolean)this.hasRequest(requests, key));
    }

    private boolean hasRequest(List<IArtifactRequest[]> requests, IArtifactKey key) {
        for (IArtifactRequest[] request : requests) {
            int i = 0;
            while (i < request.length) {
                if (key.equals(request[i].getArtifactKey())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

