/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AggregatedBundleRepository;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.EclipsePublisherHelper;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class EclipseTouchpointTest
extends AbstractProvisioningTest {
    public EclipseTouchpointTest(String name) {
        super(name);
    }

    public EclipseTouchpointTest() {
        super("");
    }

    public void testInitializeCompletePhaseCommit() {
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        HashMap<String, IProvisioningAgent> parameters = new HashMap<String, IProvisioningAgent>();
        IProfile profile = this.createProfile("test");
        parameters.put("agent", EclipseTouchpointTest.getAgent());
        touchpoint.initializePhase(null, profile, "test", parameters);
        Object manipulator = parameters.get("manipulator");
        EclipseTouchpointTest.assertNotNull(manipulator);
        EclipseTouchpointTest.assertNotNull(parameters.get("sourceBundles"));
        EclipseTouchpointTest.assertNotNull(parameters.get("platformConfiguration"));
        touchpoint.completePhase(null, profile, "test", parameters);
        parameters.clear();
        parameters.put("agent", EclipseTouchpointTest.getAgent());
        touchpoint.initializePhase(null, profile, "test2", parameters);
        Object testManipulator = parameters.get("manipulator");
        EclipseTouchpointTest.assertEquals(manipulator, testManipulator);
        touchpoint.completePhase(null, profile, "test2", parameters);
        parameters.clear();
        parameters.put("agent", EclipseTouchpointTest.getAgent());
        touchpoint.initializePhase(null, profile, "uninstall", parameters);
        testManipulator = parameters.get("manipulator");
        EclipseTouchpointTest.assertEquals(manipulator, testManipulator);
        touchpoint.completePhase(null, profile, "uninstall", parameters);
        touchpoint.commit(profile);
        touchpoint.initializePhase(null, profile, "test2", parameters);
        testManipulator = parameters.get("manipulator");
        EclipseTouchpointTest.assertNotSame(manipulator, testManipulator);
    }

    public void testQualifyAction() {
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        EclipseTouchpointTest.assertEquals((String)"org.eclipse.equinox.p2.touchpoint.eclipse.installBundle", (String)touchpoint.qualifyAction("installBundle"));
    }

    public void testBug262073() throws MalformedURLException {
        HashMap<String, String> properties = new HashMap<String, String>();
        File site = EclipseTouchpointTest.getTestData("Repository", "/testData/artifactRepo/simple with spaces/");
        URL spacesLocation = site.toURL();
        site = EclipseTouchpointTest.getTestData("Repositoy", "/testData/artifactRepo/simple/");
        URL location = site.toURL();
        properties.put("org.eclipse.equinox.p2.cache.extensions", String.valueOf(location.toString()) + "|" + spacesLocation.toString());
        IProfile profile = this.createProfile("testBug262073", properties);
        AggregatedBundleRepository repo = (AggregatedBundleRepository)Util.getAggregatedBundleRepository((IProvisioningAgent)EclipseTouchpointTest.getAgent(), (IProfile)profile);
        Collection repos = repo.testGetBundleRepositories();
        EclipseTouchpointTest.assertEquals((String)"1.0", (int)3, (int)repos.size());
    }

    public void testInitializeCompleteOperand() {
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        HashMap parameters = new HashMap();
        IProfile profile = this.createProfile("test");
        touchpoint.initializeOperand(profile, parameters);
        touchpoint.completeOperand(profile, parameters);
    }

    public void testPrepareIU() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)EclipseTouchpointTest.getAgent(), (IProfile)profile);
        File osgiSource = EclipseTouchpointTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        EclipseTouchpointTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        EclipseTouchpointTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        extraProperties.put("org.eclipse.equinox.p2.partial.iu", Boolean.TRUE.toString());
        Hashtable<String, String> mockManifest = new Hashtable<String, String>();
        ((Dictionary)mockManifest).put("Manifest-Version", "1.0");
        ((Dictionary)mockManifest).put("Bundle-ManifestVersion", "2");
        ((Dictionary)mockManifest).put("Bundle-SymbolicName", key.getId());
        ((Dictionary)mockManifest).put("Bundle-Version", key.getVersion().toString());
        BundleDescription partialIUBundleDescription = BundlesAction.createBundleDescription(mockManifest, null);
        IInstallableUnit[] bundleIUs = EclipsePublisherHelper.createEclipseIU((BundleDescription)partialIUBundleDescription, (boolean)false, (IArtifactKey)key, extraProperties);
        EclipseTouchpointTest.assertTrue((bundleIUs != null && bundleIUs.length != 0 ? 1 : 0) != 0);
        IInstallableUnit iu = bundleIUs[0];
        EclipseTouchpointTest.assertTrue((boolean)Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.partial.iu")));
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        IInstallableUnit fullIU = touchpoint.prepareIU(EclipseTouchpointTest.getAgent(), profile, iu, key);
        EclipseTouchpointTest.assertFalse((boolean)Boolean.parseBoolean(fullIU.getProperty("org.eclipse.equinox.p2.partial.iu")));
    }

    public void testInstallPartialIU() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)EclipseTouchpointTest.getAgent(), (IProfile)profile);
        File osgiSource = EclipseTouchpointTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        EclipseTouchpointTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        EclipseTouchpointTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        extraProperties.put("org.eclipse.equinox.p2.partial.iu", Boolean.TRUE.toString());
        Hashtable<String, String> mockManifest = new Hashtable<String, String>();
        ((Dictionary)mockManifest).put("Manifest-Version", "1.0");
        ((Dictionary)mockManifest).put("Bundle-ManifestVersion", "2");
        ((Dictionary)mockManifest).put("Bundle-SymbolicName", key.getId());
        ((Dictionary)mockManifest).put("Bundle-Version", key.getVersion().toString());
        BundleDescription partialIUBundleDescription = BundlesAction.createBundleDescription(mockManifest, null);
        IInstallableUnit[] bundleIUs = EclipsePublisherHelper.createEclipseIU((BundleDescription)partialIUBundleDescription, (boolean)false, (IArtifactKey)key, extraProperties);
        EclipseTouchpointTest.assertTrue((bundleIUs != null && bundleIUs.length != 0 ? 1 : 0) != 0);
        IInstallableUnit iu = bundleIUs[0];
        EclipseTouchpointTest.assertTrue((boolean)Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.partial.iu")));
        Iterator iterator = profile.query(QueryUtil.createIUQuery((String)iu.getId()), null).iterator();
        EclipseTouchpointTest.assertFalse((boolean)iterator.hasNext());
        IEngine engine = this.getEngine();
        IProvisioningPlan plan = engine.createPlan(profile, null);
        plan.addInstallableUnit(iu);
        IStatus result = engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EclipseTouchpointTest.assertTrue((boolean)result.isOK());
        engine = null;
        iterator = profile.query(QueryUtil.createIUQuery((String)iu.getId()), null).iterator();
        EclipseTouchpointTest.assertTrue((boolean)iterator.hasNext());
        IInstallableUnit installedIU = (IInstallableUnit)iterator.next();
        EclipseTouchpointTest.assertTrue((boolean)installedIU.getId().equals(iu.getId()));
        EclipseTouchpointTest.assertFalse((boolean)Boolean.parseBoolean(installedIU.getProperty("org.eclipse.equinox.p2.partial.iu")));
    }

    public void testInstallPartialIUValidationFailure() throws ProvisionException {
        File installFolder = this.getTempFolder();
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        URI site = EclipseTouchpointTest.getTestData("0.1", "/testData/updatesite/site").toURI();
        EclipseTouchpointTest.getMetadataRepositoryManager().addRepository(site);
        EclipseTouchpointTest.getArtifactRepositoryManager().addRepository(site);
        IMetadataRepository repo = EclipseTouchpointTest.getMetadataRepositoryManager().loadRepository(site, this.getMonitor());
        IInstallableUnit iu = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"test.bundle"), this.getMonitor()).iterator().next();
        EclipseTouchpointTest.assertNotNull((Object)iu);
        profile = this.createProfile("test", profileProperties);
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] newIUs = new IInstallableUnit[]{iu};
        request.addInstallableUnits(newIUs);
        IPlanner planner = EclipseTouchpointTest.createPlanner();
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, new ProvisioningContext(EclipseTouchpointTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        EclipseTouchpointTest.assertTrue((String)"1.0", (boolean)plan.getStatus().isOK());
        IStatus result = EclipseTouchpointTest.createEngine().perform(plan, this.getMonitor());
        EclipseTouchpointTest.assertFalse((String)"2.0", (boolean)result.isOK());
    }
}

