/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.AddJVMArgumentAction;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RemoveJVMArgumentAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class JVMArgumentActionLogicTest
extends AbstractProvisioningTest {
    private static File tempDir;
    private Map<String, Object> parameters;
    private LauncherData launcherData;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        tempDir = new File(System.getProperty("java.io.tmpdir"), "JVMArgs");
        tempDir.mkdirs();
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("agent", JVMArgumentActionLogicTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, JVMArgumentActionLogicTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", this.parameters);
        this.parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, this.parameters);
        this.parameters.put("profileDataDirectory", tempDir);
        Manipulator manipulator = (Manipulator)this.parameters.get("manipulator");
        JVMArgumentActionLogicTest.assertNotNull((Object)manipulator);
        this.launcherData = manipulator.getLauncherData();
    }

    @Override
    public void tearDown() throws Exception {
        AbstractProvisioningTest.delete(tempDir);
        super.tearDown();
    }

    public void testStandardUse() {
        AddJVMArgumentAction addAction = new AddJVMArgumentAction();
        RemoveJVMArgumentAction rmAction = new RemoveJVMArgumentAction();
        String maxJvmArg = "-Xmx512M";
        String minJvmArg = "-Xmx256M";
        String diffJvmArg = "-Xms50M";
        this.parameters.put("jvmArg", maxJvmArg);
        addAction.execute(this.parameters);
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(maxJvmArg));
        addAction.undo(this.parameters);
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(maxJvmArg));
        this.parameters.put("jvmArg", minJvmArg);
        addAction = new AddJVMArgumentAction();
        addAction.execute(this.parameters);
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(minJvmArg));
        this.parameters.put("jvmArg", diffJvmArg);
        addAction.execute(this.parameters);
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(minJvmArg));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(diffJvmArg));
        rmAction.execute(this.parameters);
        this.parameters.put("jvmArg", maxJvmArg);
        addAction.execute(this.parameters);
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(maxJvmArg));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(minJvmArg));
        rmAction.execute(this.parameters);
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(minJvmArg));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(maxJvmArg));
        this.parameters.put("jvmArg", minJvmArg);
        rmAction.execute(this.parameters);
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(minJvmArg));
    }

    public void testPrefixEvaluation() {
        String gigabyteArg = "-XX:MaxPermSize=1G";
        String megabyteArg = "-XX:MaxPermSize=1M";
        String kilobyteArg = "-XX:MaxPermSize=1K";
        String byteArg = "-XX:MaxPermSize=1";
        AddJVMArgumentAction addAction = new AddJVMArgumentAction();
        RemoveJVMArgumentAction rmAction = new RemoveJVMArgumentAction();
        this.parameters.put("jvmArg", byteArg);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(byteArg));
        this.parameters.put("jvmArg", kilobyteArg);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(kilobyteArg));
        this.parameters.put("jvmArg", megabyteArg);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(megabyteArg));
        this.parameters.put("jvmArg", gigabyteArg);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(gigabyteArg));
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        this.parameters.put("jvmArg", megabyteArg);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        this.parameters.put("jvmArg", kilobyteArg);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        this.parameters.put("jvmArg", byteArg);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        gigabyteArg = "-Xmx1G";
        megabyteArg = "-Xmx2048M";
        this.parameters.put("jvmArg", gigabyteArg);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(gigabyteArg));
        this.parameters.put("jvmArg", megabyteArg);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(megabyteArg));
        this.parameters.put("jvmArg", megabyteArg);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        this.parameters.put("jvmArg", gigabyteArg);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((Arrays.asList(this.launcherData.getJvmArgs()).size() == 0 ? 1 : 0) != 0);
    }

    public void testInvalidValues() {
        AddJVMArgumentAction action = new AddJVMArgumentAction();
        String invalid = "-Xms25F";
        String valid = "-Xms256M";
        this.parameters.put("jvmArg", invalid);
        IStatus result = action.execute(Collections.unmodifiableMap(this.parameters));
        if (!result.matches(4) && !(result.getException() instanceof IllegalArgumentException)) {
            JVMArgumentActionLogicTest.fail((String)"Invalid Action value not caught!");
        }
        this.launcherData.addJvmArg(invalid);
        this.parameters.put("jvmArg", valid);
        result = action.execute(Collections.unmodifiableMap(this.parameters));
        if (!result.matches(4) && !(result.getException() instanceof IllegalArgumentException)) {
            JVMArgumentActionLogicTest.fail((String)"Invalid injected value not caught!");
        }
        this.launcherData.removeJvmArg(invalid);
    }

    public void testUserInjectsInitialValue() {
        String userValue = "-Xmx400M";
        String largeValue = "-Xmx512M";
        AddJVMArgumentAction addAction = new AddJVMArgumentAction();
        RemoveJVMArgumentAction rmAction = new RemoveJVMArgumentAction();
        this.launcherData.addJvmArg(userValue);
        this.parameters.put("jvmArg", largeValue);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(largeValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(userValue));
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(largeValue));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(userValue));
        this.launcherData.removeJvmArg(userValue);
        this.parameters.put("jvmArg", "-Xmx300M");
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((Arrays.asList(this.launcherData.getJvmArgs()).size() == 0 ? 1 : 0) != 0);
    }

    public void testUserInjectsLargerValue() {
        AddJVMArgumentAction addAction = new AddJVMArgumentAction();
        RemoveJVMArgumentAction rmAction = new RemoveJVMArgumentAction();
        String userValue = "-Xmx400M";
        String initialValue = "-Xmx256M";
        String smallValue = "-Xmx100M";
        this.parameters.put("jvmArg", initialValue);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(initialValue));
        this.launcherData.removeJvmArg(initialValue);
        this.launcherData.addJvmArg(userValue);
        this.parameters.put("jvmArg", smallValue);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(userValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(initialValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(smallValue));
        this.parameters.put("jvmArg", userValue);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(userValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(initialValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(smallValue));
        this.launcherData.removeJvmArg(userValue);
        this.parameters.put("jvmArg", initialValue);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((Arrays.asList(this.launcherData.getJvmArgs()).size() == 0 ? 1 : 0) != 0);
    }

    public void testUserInjectsSmallerValue() {
        AddJVMArgumentAction addAction = new AddJVMArgumentAction();
        RemoveJVMArgumentAction rmAction = new RemoveJVMArgumentAction();
        String userValue = "-Xmx100M";
        String initialValue = "-Xmx256M";
        String largeValue = "-Xmx512M";
        this.parameters.put("jvmArg", initialValue);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(initialValue));
        this.launcherData.removeJvmArg(initialValue);
        this.launcherData.addJvmArg(userValue);
        this.parameters.put("jvmArg", largeValue);
        addAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(largeValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(initialValue));
        JVMArgumentActionLogicTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(userValue));
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        this.parameters.put("jvmArg", initialValue);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(userValue));
        this.launcherData.removeJvmArg(userValue);
        this.parameters.put("jvmArg", initialValue);
        rmAction.execute(Collections.unmodifiableMap(this.parameters));
        JVMArgumentActionLogicTest.assertTrue((Arrays.asList(this.launcherData.getJvmArgs()).size() == 0 ? 1 : 0) != 0);
    }
}

