/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.MarkStartedAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class MarkStartedActionTest
extends AbstractProvisioningTest {
    public MarkStartedActionTest(String name) {
        super(name);
    }

    public MarkStartedActionTest() {
        super("");
    }

    public void testExecuteUndo() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)MarkStartedActionTest.getAgent(), (IProfile)profile);
        File osgiSource = MarkStartedActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        MarkStartedActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        MarkStartedActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", MarkStartedActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("started", Boolean.TRUE.toString());
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        MarkStartedActionTest.assertNotNull((Object)manipulator);
        BundleInfo bundleInfo = Util.createBundleInfo((File)osgiTarget, (IInstallableUnit)iu);
        manipulator.getConfigData().addBundle(bundleInfo);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
        MarkStartedAction action = new MarkStartedAction();
        action.execute(parameters);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, true));
        action.undo(parameters);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
    }

    public void testExecuteUndoWithMissingArtifact() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)MarkStartedActionTest.getAgent(), (IProfile)profile);
        File osgiSource = MarkStartedActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        MarkStartedActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        MarkStartedActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", MarkStartedActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("started", Boolean.TRUE.toString());
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        MarkStartedActionTest.assertNotNull((Object)manipulator);
        BundleInfo bundleInfo = Util.createBundleInfo((File)osgiTarget, (IInstallableUnit)iu);
        manipulator.getConfigData().addBundle(bundleInfo);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
        bundlePool.removeDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        MarkStartedAction action = new MarkStartedAction();
        action.execute(parameters);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, true));
        action.undo(parameters);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
    }

    public void testExecuteOnFragmentBundleResultsInBundleNotBeingMarkedStarted() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)MarkStartedActionTest.getAgent(), (IProfile)profile);
        File osgiSource = MarkStartedActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi.fragment_1.0.0.jar");
        File targetPlugins = new File(installFolder, "plugins");
        MarkStartedActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi.fragment_1.0.0.jar");
        MarkStartedActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", MarkStartedActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("started", Boolean.TRUE.toString());
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        MarkStartedActionTest.assertNotNull((Object)manipulator);
        BundleInfo bundleInfo = Util.createBundleInfo((File)osgiTarget, (IInstallableUnit)iu);
        manipulator.getConfigData().addBundle(bundleInfo);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
        MarkStartedAction action = new MarkStartedAction();
        action.execute(parameters);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
        action.undo(parameters);
        MarkStartedActionTest.assertTrue((boolean)this.isMarkedStarted(manipulator, osgiTarget, false));
    }

    private boolean isMarkedStarted(Manipulator manipulator, File osgiTarget, boolean started) {
        URI location = osgiTarget.toURI();
        BundleInfo[] bundles = manipulator.getConfigData().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (location.equals(bundles[i].getLocation()) && started == bundles[i].isMarkedAsStarted()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

