/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.p2.update.PathUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PathUtilTest
extends AbstractProvisioningTest {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public void testMakeRelative() throws MalformedURLException {
        if (!WINDOWS) {
            return;
        }
        Object[][] data = new Object[][]{{"file:/c:/a/b", new URL("file:/c:/a/x"), "file:../b"}, {"file:/c:/eclipse/plugins/foo.jar", new URL("file:/c:/eclipse/"), "file:plugins\\foo.jar"}, {"file:/c:/a/b", new URL("file:/d:/a/x"), "file:/c:/a/b"}, {"file:/c:/eclipse/plugins/foo.jar", new URL("file:/d:/eclipse/"), "file:/c:/eclipse/plugins/foo.jar"}, {"http:/c:/a/b", new URL("file:/c:/a/x"), "http:/c:/a/b"}, {"file:/c:/a/b", new URL("http:/c:/a/x"), "file:/c:/a/b"}, {"file:/c:/a/b", new URL("file:/C:/a/x"), "file:../b"}, {"file:/c:/", new URL("file:/d:/"), "file:/c:/"}, {"file:/c:/", new URL("file:/c:/"), "file:/c:/"}};
        int i = 0;
        while (i < data.length) {
            String location = data[i][0].toString();
            URL root = (URL)data[i][1];
            String expected = data[i][2].toString();
            String actual = PathUtil.makeRelative((String)location, (URL)root);
            PathUtilTest.assertEquals((String)("2." + Integer.toString(i)), (String)expected, (String)actual);
            ++i;
        }
    }
}

