/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.util.HashMap;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RemoveProgramPropertyAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class RemoveProgramPropertyActionTest
extends AbstractProvisioningTest {
    public RemoveProgramPropertyActionTest(String name) {
        super(name);
    }

    public RemoveProgramPropertyActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", RemoveProgramPropertyActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, RemoveProgramPropertyActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        RemoveProgramPropertyActionTest.assertNotNull((Object)manipulator);
        ConfigData data = manipulator.getConfigData();
        String key = RemoveProgramPropertyActionTest.getUniqueString();
        String value1 = "foo";
        String value2 = "bar";
        String value3 = "quux";
        String initial = String.valueOf(value1) + "," + value2 + "," + value3;
        RemoveProgramPropertyActionTest.assertNull((Object)data.getProperty(key));
        data.setProperty(key, initial);
        parameters.put("propName", key);
        parameters.put("propValue", value2);
        RemoveProgramPropertyAction action = new RemoveProgramPropertyAction();
        action.execute(parameters);
        String current = data.getProperty(key);
        RemoveProgramPropertyActionTest.assertNotNull((Object)current);
        RemoveProgramPropertyActionTest.assertEquals((String)(String.valueOf(value1) + "," + value3), (String)current);
        action.undo(parameters);
        current = data.getProperty(key);
        RemoveProgramPropertyActionTest.assertNotNull((Object)current);
        RemoveProgramPropertyActionTest.assertEquals((String)initial, (String)current);
        data.setProperty(key, null);
    }
}

