/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.SetProgramPropertyAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class SetProgramPropertyActionTest
extends AbstractProvisioningTest {
    public SetProgramPropertyActionTest(String name) {
        super(name);
    }

    public SetProgramPropertyActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", SetProgramPropertyActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, SetProgramPropertyActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetProgramPropertyActionTest.assertNotNull((Object)manipulator);
        String frameworkDependentPropertyName = "test";
        String frameworkDependentPropertyValue = "true";
        SetProgramPropertyActionTest.assertFalse((boolean)manipulator.getConfigData().getProperties().containsKey(frameworkDependentPropertyName));
        parameters.put("propName", frameworkDependentPropertyName);
        parameters.put("propValue", frameworkDependentPropertyValue);
        parameters = Collections.unmodifiableMap(parameters);
        SetProgramPropertyAction action = new SetProgramPropertyAction();
        action.execute(parameters);
        SetProgramPropertyActionTest.assertEquals((String)"true", (String)manipulator.getConfigData().getProperty(frameworkDependentPropertyName));
        action.undo(parameters);
        SetProgramPropertyActionTest.assertFalse((boolean)manipulator.getConfigData().getProperties().containsKey(frameworkDependentPropertyName));
    }

    public void testExecuteUndoWithArtifact() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)SetProgramPropertyActionTest.getAgent(), (IProfile)profile);
        File osgiSource = SetProgramPropertyActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        SetProgramPropertyActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        SetProgramPropertyActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", SetProgramPropertyActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetProgramPropertyActionTest.assertNotNull((Object)manipulator);
        String resolvedArtifact = osgiTarget.getAbsolutePath();
        SetProgramPropertyActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        parameters.put("propName", "test");
        parameters.put("propValue", "@artifact");
        parameters = Collections.unmodifiableMap(parameters);
        SetProgramPropertyAction action = new SetProgramPropertyAction();
        action.execute(parameters);
        SetProgramPropertyActionTest.assertTrue((boolean)manipulator.getConfigData().getProperty("test").equals(resolvedArtifact));
        action.undo(parameters);
        SetProgramPropertyActionTest.assertFalse((boolean)manipulator.getConfigData().getProperties().containsKey("test"));
        action.execute(parameters);
        SetProgramPropertyActionTest.assertTrue((boolean)manipulator.getConfigData().getProperty("test").equals(resolvedArtifact));
        parameters = new HashMap(parameters);
        parameters.remove("propValue");
        parameters = Collections.unmodifiableMap(parameters);
        action.execute(parameters);
        SetProgramPropertyActionTest.assertFalse((boolean)manipulator.getConfigData().getProperties().containsKey("test"));
        action.undo(parameters);
        SetProgramPropertyActionTest.assertTrue((boolean)manipulator.getConfigData().getProperty("test").equals(resolvedArtifact));
    }

    public void testExecuteUndoWithArtifactLocation() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)SetProgramPropertyActionTest.getAgent(), (IProfile)profile);
        File osgiSource = SetProgramPropertyActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        SetProgramPropertyActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        SetProgramPropertyActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", SetProgramPropertyActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetProgramPropertyActionTest.assertNotNull((Object)manipulator);
        String resolvedArtifact = osgiTarget.getAbsolutePath();
        SetProgramPropertyActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getProgramArgs()).contains(resolvedArtifact));
        parameters.put("propName", "test");
        parameters.put("propValue", parameters.get("artifact.location"));
        parameters = Collections.unmodifiableMap(parameters);
        SetProgramPropertyAction action = new SetProgramPropertyAction();
        action.execute(parameters);
        SetProgramPropertyActionTest.assertTrue((boolean)manipulator.getConfigData().getProperty("test").equals(resolvedArtifact));
        action.undo(parameters);
        SetProgramPropertyActionTest.assertFalse((boolean)manipulator.getConfigData().getProperties().containsKey("test"));
        action.execute(parameters);
        SetProgramPropertyActionTest.assertTrue((boolean)manipulator.getConfigData().getProperty("test").equals(resolvedArtifact));
        parameters = new HashMap(parameters);
        parameters.remove("propValue");
        parameters = Collections.unmodifiableMap(parameters);
        action.execute(parameters);
        SetProgramPropertyActionTest.assertFalse((boolean)manipulator.getConfigData().getProperties().containsKey("test"));
        action.undo(parameters);
        SetProgramPropertyActionTest.assertTrue((boolean)manipulator.getConfigData().getProperty("test").equals(resolvedArtifact));
    }
}

