/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.BackupStore;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class BackupStoreTest
extends AbstractProvisioningTest {
    private static final String BUPREFIX = "BackupTest";
    private File sourceDir;
    private File aDir;
    private File aaDir;
    private File aTxt;
    private File bDir;
    private File bTxt;

    @Override
    public void setUp() {
        String userHome = System.getProperty("user.home");
        this.sourceDir = new File(new File(userHome), "P2BUTEST");
        this.fullyDelete(this.sourceDir);
        this.aDir = new File(this.sourceDir, "A");
        this.aDir.mkdirs();
        this.aaDir = new File(this.aDir, "AA");
        this.aaDir.mkdir();
        this.aTxt = new File(this.aaDir, "eclipse.exe");
        this.bDir = new File(this.sourceDir, "B");
        this.bTxt = new File(this.bDir, "b.txt");
        try {
            this.writeToFile(this.aTxt, "A\nA file with an A");
        }
        catch (IOException iOException) {
            BackupStoreTest.fail();
        }
    }

    private void writeToFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void tearDown() {
        this.fullyDelete(this.sourceDir);
    }

    private boolean fullyDelete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                if (!this.fullyDelete(new File(file, children[i].getName()))) {
                    return false;
                }
                ++i;
            }
        }
        return file.delete();
    }

    public void testBackupByRenamingFile() {
        String filePath = this.aTxt.getAbsolutePath();
        new BackupStore(null, BUPREFIX){

            public void renameInPlace(File file) {
                super.renameInPlace(file);
            }

            protected String getTimeStamp() {
                return "-123";
            }
        }.renameInPlace(this.aTxt);
        BackupStoreTest.assertFalse((boolean)this.aTxt.exists());
        BackupStoreTest.assertTrue((boolean)new File(String.valueOf(filePath) + "-123.p2bu").exists());
    }

    public void testRenameIfMoveToBackupFails() throws IOException {
        String filePath = this.aTxt.getAbsolutePath();
        new BackupStore(null, BUPREFIX){

            public void renameInPlace(File file) {
                super.renameInPlace(file);
            }

            public boolean moveToBackupStore(File a, File b) {
                return false;
            }

            public void moveToBackup(File a, File b) throws IOException {
                super.moveToBackup(a, b);
            }

            protected String getTimeStamp() {
                return "-123";
            }
        }.moveToBackup(this.aTxt, this.bTxt);
        BackupStoreTest.assertFalse((boolean)this.aTxt.exists());
        BackupStoreTest.assertTrue((boolean)new File(String.valueOf(filePath) + "-123.p2bu").exists());
        BackupStoreTest.assertFalse((boolean)this.bTxt.exists());
    }

    public void testDoNotRenameIfMoveToBackupWorks() throws IOException {
        String filePath = this.aTxt.getAbsolutePath();
        new BackupStore(null, BUPREFIX){

            public void renameInPlace(File file) {
                super.renameInPlace(file);
            }

            public boolean moveToBackupStore(File a, File b) {
                return super.moveToBackupStore(a, b);
            }

            public void moveToBackup(File a, File b) throws IOException {
                super.moveToBackup(a, b);
            }
        }.moveToBackup(this.aTxt, this.bTxt);
        BackupStoreTest.assertFalse((boolean)this.aTxt.exists());
        BackupStoreTest.assertFalse((boolean)new File(String.valueOf(filePath) + ".p2bu").exists());
        BackupStoreTest.assertTrue((boolean)this.bTxt.exists());
    }
}

