/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.ChmodAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ChmodActionTest
extends AbstractProvisioningTest {
    public ChmodActionTest(String name) {
        super(name);
    }

    public ChmodActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndo", profileProperties);
        File zipSource = ChmodActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        ChmodActionTest.copy("2.0", zipSource, zipTarget);
        File subDir = new File(installFolder, "subfolder");
        subDir.mkdir();
        File zipTarget2 = new File(subDir, "a.zip");
        ChmodActionTest.copy("3.0", zipSource, zipTarget2);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "testExecuteUndo", parameters);
        parameters.put("targetDir", installFolder.getAbsolutePath());
        parameters.put("targetFile", "a.zip");
        parameters.put("permissions", "+x");
        Map xparameters = Collections.unmodifiableMap(parameters);
        ChmodAction action = new ChmodAction();
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R");
        parameters.put("targetFile", "subfolder");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("options", "-R -H");
        parameters.put("targetFile", "subfolder");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        action.execute(xparameters);
        action.undo(xparameters);
        action = new ChmodAction();
        parameters.put("targetFile", "JimmyHoffa");
        parameters.put("permissions", "700");
        xparameters = Collections.unmodifiableMap(parameters);
        IStatus result = action.execute(xparameters);
        ChmodActionTest.assertFalse((String)"Missing file should result in error", (boolean)result.isOK());
        action.undo(xparameters);
    }
}

