/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CleanupzipAction;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class CleanupzipActionTest
extends AbstractProvisioningTest {
    IBackupStore store;

    public CleanupzipActionTest(String name) {
        super(name);
    }

    public CleanupzipActionTest() {
        super("");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.discard();
        }
    }

    public void testExecuteUndo() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndo", profileProperties);
        File zipSource = CleanupzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        CleanupzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testExecuteUndo", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "testExecuteUndo", parameters);
        this.store = (IBackupStore)parameters.get("backup");
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        File aTxt = new File(installFolder, "a.txt");
        new UnzipAction().execute(parameters);
        CleanupzipActionTest.assertTrue((boolean)aTxt.exists());
        CleanupzipActionTest.assertEquals((int)1, (int)profile.getInstallableUnitProperties(iu).size());
        CleanupzipAction action = new CleanupzipAction();
        action.execute(parameters);
        CleanupzipActionTest.assertFalse((boolean)aTxt.exists());
        CleanupzipActionTest.assertEquals((int)0, (int)profile.getInstallableUnitProperties(iu).size());
        action.undo(parameters);
        CleanupzipActionTest.assertTrue((boolean)aTxt.exists());
        CleanupzipActionTest.assertEquals((int)1, (int)profile.getInstallableUnitProperties(iu).size());
    }

    public void testExecuteUndoWhereInstallFolderIsDifferent() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndoWhereInstallFolderIsDifferent", profileProperties);
        File zipSource = CleanupzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        CleanupzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"test", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        this.store = (IBackupStore)parameters.get("backup");
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        File aTxt = new File(installFolder, "a.txt");
        new UnzipAction().execute(parameters);
        CleanupzipActionTest.assertTrue((boolean)aTxt.exists());
        CleanupzipActionTest.assertEquals((int)1, (int)profile.getInstallableUnitProperties(iu).size());
        File installFolder2 = this.getTempFolder();
        CleanupzipActionTest.copy("", installFolder, installFolder2);
        parameters.put("target", installFolder2.getAbsolutePath());
        CleanupzipAction action = new CleanupzipAction();
        action.execute(parameters);
        File aTxt2 = new File(installFolder2, "a.txt");
        CleanupzipActionTest.assertFalse((boolean)aTxt2.exists());
        CleanupzipActionTest.assertEquals((int)0, (int)profile.getInstallableUnitProperties(iu).size());
        action.undo(parameters);
        CleanupzipActionTest.assertTrue((boolean)aTxt2.exists());
        CleanupzipActionTest.assertEquals((int)1, (int)profile.getInstallableUnitProperties(iu).size());
    }

    public void testDirectoryCleanup() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndo", profileProperties);
        File zipSource = CleanupzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/nestedFolder.zip");
        File zipTarget = new File(installFolder, "nestedFolder.zip");
        CleanupzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testDirectoryCleanup", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "testDirectoryCleanup", parameters);
        this.store = (IBackupStore)parameters.get("backup");
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        new UnzipAction().execute(parameters);
        CleanupzipActionTest.assertEquals((int)1, (int)profile.getInstallableUnitProperties(iu).size());
        File aTxt = new File(installFolder, "nestedFolder/innerFolder/a.txt");
        File innerFolder = new File(installFolder, "nestedFolder/innerFolder");
        File nestedFolder = new File(installFolder, "nestedFolder");
        CleanupzipActionTest.assertTrue((String)("File " + aTxt.getAbsolutePath() + " should exist"), (boolean)aTxt.exists());
        CleanupzipActionTest.assertTrue((String)("Folder " + innerFolder.getAbsolutePath() + " should exist"), (boolean)innerFolder.exists());
        CleanupzipActionTest.assertTrue((String)("Folder " + nestedFolder.getAbsolutePath() + " should exist"), (boolean)nestedFolder.exists());
        CleanupzipAction action = new CleanupzipAction();
        action.execute(parameters);
        CleanupzipActionTest.assertEquals((int)0, (int)profile.getInstallableUnitProperties(iu).size());
        CleanupzipActionTest.assertFalse((String)("File " + aTxt.getAbsolutePath() + " should not exist"), (boolean)aTxt.exists());
        CleanupzipActionTest.assertFalse((String)("Folder " + innerFolder.getAbsolutePath() + " should not exist"), (boolean)innerFolder.exists());
        CleanupzipActionTest.assertFalse((String)("Folder " + nestedFolder.getAbsolutePath() + " should not exist"), (boolean)nestedFolder.exists());
    }
}

