/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CollectAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class CollectActionTest
extends AbstractProvisioningTest {
    public CollectActionTest(String name) {
        super(name);
    }

    public CollectActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"test", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", CollectActionTest.getAgent());
        parameters.put("profile", profile);
        parameters.put("artifactRequests", new ArrayList());
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("iu", iu);
        touchpoint.initializeOperand(profile, parameters);
        parameters = Collections.unmodifiableMap(parameters);
        List requests = (List)parameters.get("artifactRequests");
        CollectActionTest.assertFalse((boolean)this.hasRequest(requests, (IArtifactKey)key));
        CollectAction action = new CollectAction();
        action.execute(parameters);
        CollectActionTest.assertTrue((boolean)this.hasRequest(requests, (IArtifactKey)key));
        action.undo(parameters);
        CollectActionTest.assertTrue((boolean)this.hasRequest(requests, (IArtifactKey)key));
    }

    private boolean hasRequest(List<IArtifactRequest[]> requests, IArtifactKey key) {
        for (IArtifactRequest[] request : requests) {
            int i = 0;
            while (i < request.length) {
                if (key.equals(request[i].getArtifactKey())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

