/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatesite;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorSelector;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.artifact.UpdateSiteArtifactRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.AbstractRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpdateSiteTest
extends AbstractProvisioningTest {
    public UpdateSiteTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(UpdateSiteTest.class);
    }

    public void testRelativeSiteURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/siteurl");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testAbsoluteSiteURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/siteurl2");
        File siteDirectory = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/siteurl2/siteurl/");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            updatesite.getSite().setLocationURIString(siteDirectory.toURI().toString());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testDefaultDigestURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/digest");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testZippedDefaultDigestURL() throws URISyntaxException {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/digest/site.zip");
        URI siteURI = new URI("jar:" + site.toURI() + "!/");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)siteURI, (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testRelativeDigestURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/digesturl");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testAbsoluteDigestURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/digesturl2");
        File digestDirectory = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/digesturl2/digesturl/");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            updatesite.getSite().setDigestURIString(digestDirectory.toURI().toString());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testNoDigestGoodSite() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/site");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testNoEndingSlashURL() {
        File base = UpdateSiteTest.getTestData("0.1", "/testData/updatesite");
        UpdateSite updatesite = null;
        try {
            URI siteURL = base.toURI().resolve("site");
            updatesite = UpdateSite.load((URI)siteURL, (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testSiteXMLURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/site/site.xml");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures(this.getMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testSiteWithSpaces() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/site with spaces/");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testXXXSiteXXXXMLURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/xxxsitexxx/xxxsitexxx.xml");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testBadXXXSiteXXXXMLURL() {
        File siteDir = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/xxxsitexxx");
        File site = new File(siteDir, "site.xml");
        try {
            UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            UpdateSiteTest.fail((String)"0.2");
        }
        catch (ProvisionException provisionException) {}
    }

    public void testBadDigestGoodSite() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/baddigestgoodsite");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.4", e);
        }
    }

    public void testCorruptDigestGoodSite() {
        StringBuffer buffer;
        block7: {
            File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/corruptdigestgoodsite");
            UpdateSite updatesite = null;
            try {
                updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            }
            catch (ProvisionException e) {
                UpdateSiteTest.fail("0.2", e);
            }
            buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor());
                }
                catch (ProvisionException e) {
                    UpdateSiteTest.fail("0.4", e);
                    System.setOut(out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        UpdateSiteTest.assertTrue((boolean)buffer.toString().contains("Content is not allowed in prolog."));
    }

    public void testBadDigestBadSite() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/baddigestbadsite");
        try {
            UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            UpdateSiteTest.fail((String)"0.2");
        }
        catch (ProvisionException provisionException) {}
    }

    public void testBadSiteXML() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/badSiteXML");
        try {
            UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            UpdateSiteTest.fail((String)"0.2");
        }
        catch (ProvisionException provisionException) {}
    }

    public void testNoSite() {
        File temp = this.getTempFolder();
        temp.mkdirs();
        try {
            UpdateSite.load((URI)temp.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            UpdateSiteTest.fail((String)"0.2");
        }
        catch (ProvisionException provisionException) {}
    }

    public void testNullSite() {
        try {
            UpdateSiteTest.assertNull((String)"1.0", (Object)UpdateSite.load(null, (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor()));
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("1.99", e);
        }
    }

    public void testBadFeatureURL() {
        StringBuffer buffer;
        block7: {
            File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/badfeatureurl");
            UpdateSite updatesite = null;
            try {
                updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            }
            catch (ProvisionException e) {
                UpdateSiteTest.fail("0.2", e);
            }
            buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
                    UpdateSiteTest.assertEquals((int)0, (int)featureCount);
                }
                catch (ProvisionException provisionException) {
                    UpdateSiteTest.fail((String)"0.5");
                    System.setOut(out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        UpdateSiteTest.assertTrue((boolean)buffer.toString().contains("Error reading feature"));
    }

    public void testGoodFeatureURL() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/goodfeatureurl");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"0.5");
        }
    }

    public void testZippedGoodFeatureURL() throws URISyntaxException {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/goodfeatureurl/site.zip");
        URI siteURI = new URI("jar:" + site.toURI() + "!/");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)siteURI, (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)1, (int)featureCount);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"0.5");
        }
    }

    public void testIncludedFeature() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/includedfeature");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)2, (int)featureCount);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"0.5");
        }
    }

    public void testIncludedFeatureArchive() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/includedfeaturearchive");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)2, (int)featureCount);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"0.5");
        }
    }

    public void testBadIncludedFeatureArchive() {
        StringBuffer buffer;
        block7: {
            File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/badincludedfeaturearchive");
            UpdateSite updatesite = null;
            try {
                updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
            }
            catch (ProvisionException e) {
                UpdateSiteTest.fail("0.2", e);
            }
            buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
                    UpdateSiteTest.assertEquals((int)1, (int)featureCount);
                }
                catch (ProvisionException provisionException) {
                    UpdateSiteTest.fail((String)"0.5");
                    System.setOut(out);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        UpdateSiteTest.assertTrue((boolean)buffer.toString().contains("Error reading feature"));
    }

    public void testNoFeatureIdAndVersion() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/nofeatureidandversion");
        UpdateSite updatesite = null;
        try {
            updatesite = UpdateSite.load((URI)site.toURI(), (Transport)this.getTransport(), (IProgressMonitor)this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        try {
            int featureCount = updatesite.loadFeatures((IProgressMonitor)new NullProgressMonitor()).length;
            UpdateSiteTest.assertEquals((int)2, (int)featureCount);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"0.5");
        }
    }

    public void testSiteFeatureVersionEquals() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (Object)a, (Object)b);
        b.setFeatureVersion("1.0.0");
        a.setFeatureVersion("1.0.0");
        b.setFeatureVersion("1.0.0");
        UpdateSiteTest.assertEquals((String)"1.1", (Object)a, (Object)b);
        b.setFeatureVersion("2.0.0");
        UpdateSiteTest.assertFalse((String)"1.2", (boolean)a.equals((Object)b));
        b.setFeatureVersion(null);
        UpdateSiteTest.assertFalse((String)"1.3", (boolean)a.equals((Object)b));
        UpdateSiteTest.assertFalse((String)"1.4", (boolean)b.equals((Object)a));
    }

    public void testSiteFeatureLabelEquals() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (Object)a, (Object)b);
        a.setLabel("foo");
        b.setLabel("foo");
        UpdateSiteTest.assertEquals((String)"1.1", (Object)a, (Object)b);
        b.setLabel("bar");
        UpdateSiteTest.assertFalse((String)"1.2", (boolean)a.equals((Object)b));
        b.setLabel(null);
        UpdateSiteTest.assertFalse((String)"1.3", (boolean)a.equals((Object)b));
        UpdateSiteTest.assertFalse((String)"1.4", (boolean)b.equals((Object)a));
    }

    public void testSiteFeatureIDEquals() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (Object)a, (Object)b);
        a.setFeatureIdentifier("org.foo");
        b.setFeatureIdentifier("org.foo");
        UpdateSiteTest.assertEquals((String)"1.1", (Object)a, (Object)b);
        b.setFeatureIdentifier("org.bar");
        UpdateSiteTest.assertFalse((String)"1.2", (boolean)a.equals((Object)b));
        b.setFeatureIdentifier(null);
        UpdateSiteTest.assertFalse((String)"1.3", (boolean)a.equals((Object)b));
        UpdateSiteTest.assertFalse((String)"1.4", (boolean)b.equals((Object)a));
    }

    public void testSiteFeatureEquals() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (Object)a, (Object)b);
        a.setURLString("http://foo");
        UpdateSiteTest.assertFalse((String)"1.1", (boolean)a.equals((Object)b));
        b.setURLString("http://foo");
        UpdateSiteTest.assertEquals((String)"1.2", (Object)a, (Object)b);
        a.setURLString("http://FOO");
        UpdateSiteTest.assertEquals((String)"1.3", (Object)a, (Object)b);
        a.setURLString("file://FOO");
        UpdateSiteTest.assertFalse((String)"1.4", (boolean)a.equals((Object)b));
        a.setURLString(null);
        UpdateSiteTest.assertFalse((String)"1.5", (boolean)a.equals((Object)b));
        UpdateSiteTest.assertFalse((String)"1.6", (boolean)b.equals((Object)a));
    }

    public void testSiteFeatureHash() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (int)a.hashCode(), (int)b.hashCode());
        a.setURLString("http://foo");
        b.setURLString("http://foo");
        UpdateSiteTest.assertEquals((String)"1.1", (int)a.hashCode(), (int)b.hashCode());
        a.setURLString("http://FOO/");
        UpdateSiteTest.assertEquals((String)"1.2", (int)a.hashCode(), (int)b.hashCode());
        a.setURLString("foo");
        b.setURLString("FoO");
        UpdateSiteTest.assertEquals((String)"1.3", (int)a.hashCode(), (int)b.hashCode());
    }

    public void testSiteFeatureNotEquals() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (Object)a, (Object)b);
        a.setURLString("file:/c:/foo");
        UpdateSiteTest.assertFalse((String)"1.1", (boolean)a.equals((Object)b));
        b.setURLString("file:/c:/bar");
        UpdateSiteTest.assertFalse((String)"1.2", (boolean)a.equals((Object)b));
        UpdateSiteTest.assertFalse((String)"1.3", (boolean)b.equals((Object)a));
        a.setURLString("http://foo");
        b.setURLString("http://bar/");
        UpdateSiteTest.assertFalse((String)"1.4", (boolean)b.equals((Object)a));
    }

    public void testSiteFeatureFileURL() {
        SiteFeature a = new SiteFeature();
        SiteFeature b = new SiteFeature();
        UpdateSiteTest.assertEquals((String)"1.0", (Object)a, (Object)b);
        a.setURLString("file:/c:/foo");
        b.setURLString("file:/c:/FOO");
        if (a.equals((Object)b)) {
            UpdateSiteTest.assertEquals((String)"1.1", (int)a.hashCode(), (int)b.hashCode());
        }
        a.setURLString("FILE:/c:/foo");
        b.setURLString("file:/c:/FOO");
        if (a.equals((Object)b)) {
            UpdateSiteTest.assertEquals((String)"1.2", (int)a.hashCode(), (int)b.hashCode());
        }
        a.setURLString("HTTP://example.com");
        b.setURLString("HTtP://example.com");
        if (a.equals((Object)b)) {
            UpdateSiteTest.assertEquals((String)"1.3", (int)a.hashCode(), (int)b.hashCode());
        }
        a.setURLString("HTTP://eXaMpLe.com");
        b.setURLString("HTtP://example.com");
        if (a.equals((Object)b)) {
            UpdateSiteTest.assertEquals((String)"1.4", (int)a.hashCode(), (int)b.hashCode());
        }
        a.setURLString("HTTP://eXaMpLe.com/");
        b.setURLString("HTtP://example.com");
        UpdateSiteTest.assertEquals((Object)a, (Object)b);
        if (a.equals((Object)b)) {
            UpdateSiteTest.assertEquals((String)"1.5", (int)a.hashCode(), (int)b.hashCode());
        }
        a.setURLString("http://localhost");
        b.setURLString("http://127.0.0.1");
        if (a.equals((Object)b)) {
            UpdateSiteTest.assertEquals((String)"1.6", (int)a.hashCode(), (int)b.hashCode());
        }
    }

    public void testRepoWithFeatureWithNullUpdateURL() {
        StringBuffer buffer;
        IMetadataRepository metadataRepo;
        block5: {
            IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)UpdateSiteTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
            UpdateSiteTest.assertNotNull((Object)repoMan);
            File site = UpdateSiteTest.getTestData("Update site", "/testData/updatesite/missingUpdateURLFeature/");
            metadataRepo = null;
            buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    metadataRepo = repoMan.loadRepository(site.toURI(), null);
                }
                catch (ProvisionException provisionException) {
                    UpdateSiteTest.fail((String)"Can't load repository missingUpdateURLFeature");
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        UpdateSiteTest.assertTrue((boolean)buffer.toString().contains("Invalid site reference null in feature test.featurewithmissingupdateurl."));
        IQuery query = QueryUtil.createIUQuery((String)"test.featurewithmissingupdateurl.feature.group", (Version)Version.create((String)"1.0.0"));
        IQueryResult result = metadataRepo.query(query, null);
        UpdateSiteTest.assertEquals((String)"1.0", (int)1, (int)UpdateSiteTest.queryResultSize(result));
    }

    public void testBug243422() {
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)UpdateSiteTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        UpdateSiteTest.assertNotNull((Object)repoMan);
        File site = UpdateSiteTest.getTestData("Update site", "/testData/updatesite/UpdateSite243422/");
        IMetadataRepository metadataRepo = null;
        try {
            metadataRepo = repoMan.loadRepository(site.toURI(), null);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"Can't load repository UpdateSite243422");
        }
        IQuery query = QueryUtil.createIUQuery((String)"org.eclipse.jdt.astview.feature.feature.group", (Version)Version.create((String)"1.0.1"));
        IQueryResult result = metadataRepo.query(query, null);
        UpdateSiteTest.assertEquals((String)"1.0", (int)1, (int)UpdateSiteTest.queryResultSize(result));
        IInstallableUnit featureIU = (IInstallableUnit)result.iterator().next();
        Collection required = featureIU.getRequirements();
        for (IRequiredCapability req : required) {
            if (!req.getName().equals("org.eclipse.ui.ide")) continue;
            UpdateSiteTest.assertEquals((String)"2.0", (Object)VersionRange.emptyRange, (Object)req.getRange());
        }
    }

    public void testShortenVersionNumberInFeature() {
        IArtifactRepositoryManager repoMan = (IArtifactRepositoryManager)UpdateSiteTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        UpdateSiteTest.assertNotNull((Object)repoMan);
        File site = UpdateSiteTest.getTestData("Update site", "/testData/updatesite/240121/UpdateSite240121/");
        IArtifactRepository artifactRepo = null;
        try {
            artifactRepo = repoMan.loadRepository(site.toURI(), null);
        }
        catch (ProvisionException provisionException) {
            UpdateSiteTest.fail((String)"Can't load repository UpdateSite240121");
        }
        IQueryResult keys = artifactRepo.query((IQuery)new ArtifactKeyQuery(null, "Plugin240121", null), null);
        UpdateSiteTest.assertEquals((int)1, (int)UpdateSiteTest.queryResultSize(keys));
        IArtifactKey key = (IArtifactKey)keys.iterator().next();
        IStatus status = artifactRepo.getArtifact(artifactRepo.getArtifactDescriptors(key)[0], (OutputStream)new ByteArrayOutputStream(500), (IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            UpdateSiteTest.fail((String)("Can't get the expected artifact:" + key));
        }
    }

    public void testFeatureJarUnzipInstruction() {
        IMetadataRepository repository;
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)UpdateSiteTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/site");
        URI location = null;
        location = site.toURI();
        try {
            repository = repoMan.loadRepository(location, this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("1.99", e);
            return;
        }
        IQueryResult result = repository.query(QueryUtil.createIUQuery((String)"test.feature.feature.jar"), this.getMonitor());
        UpdateSiteTest.assertTrue((String)"1.0", (!result.isEmpty() ? 1 : 0) != 0);
        IInstallableUnit unit = (IInstallableUnit)result.iterator().next();
        Collection data = unit.getTouchpointData();
        UpdateSiteTest.assertEquals((String)"1.1", (int)1, (int)data.size());
        Map instructions = ((ITouchpointData)data.iterator().next()).getInstructions();
        UpdateSiteTest.assertEquals((String)"1.2", (int)1, (int)instructions.size());
        UpdateSiteTest.assertEquals((String)"1.3", (String)"true", (String)((ITouchpointInstruction)instructions.get("zipped")).getBody());
    }

    public void _testFeatureSiteReferences() throws ProvisionException, URISyntaxException {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/siteFeatureReferences");
        URI siteURI = site.toURI();
        URI testUpdateSite = new URI("http://download.eclipse.org/test/updatesite/");
        URI testDiscoverySite = new URI("http://download.eclipse.org/test/discoverysite");
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)UpdateSiteTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        UpdateSiteTest.assertNotNull((Object)manager);
        manager.removeRepository(testUpdateSite);
        manager.removeRepository(testDiscoverySite);
        IMetadataRepository repository = manager.loadRepository(siteURI, 0, this.getMonitor());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            UpdateSiteTest.fail("4.99", e);
        }
        UpdateSiteTest.assertNotNull((Object)repository);
        UpdateSiteTest.assertTrue((String)"1.0", (boolean)manager.contains(testUpdateSite));
        UpdateSiteTest.assertTrue((String)"1.1", (boolean)manager.contains(testDiscoverySite));
        UpdateSiteTest.assertFalse((String)"1.2", (boolean)manager.isEnabled(testUpdateSite));
        UpdateSiteTest.assertFalse((String)"1.3", (boolean)manager.isEnabled(testDiscoverySite));
    }

    public void testMetadataRepoCount() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/site");
        URI siteURI = site.toURI();
        IMetadataRepositoryManager metadataRepoMan = (IMetadataRepositoryManager)UpdateSiteTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        UpdateSiteTest.assertNotNull((Object)metadataRepoMan);
        URI[] knownRepos = metadataRepoMan.getKnownRepositories(0);
        int i = 0;
        while (i < knownRepos.length) {
            if (siteURI.equals(knownRepos[i])) {
                metadataRepoMan.removeRepository(siteURI);
                knownRepos = metadataRepoMan.getKnownRepositories(0);
                break;
            }
            ++i;
        }
        try {
            metadataRepoMan.loadRepository(site.toURI(), this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("1.0", e);
            return;
        }
        URI[] afterKnownRepos = metadataRepoMan.getKnownRepositories(0);
        UpdateSiteTest.assertTrue((String)"1.1", (afterKnownRepos.length == knownRepos.length + 1 ? 1 : 0) != 0);
    }

    public void testArtifactRepoCount() {
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/site");
        URI siteURI = site.toURI();
        IArtifactRepositoryManager artifactRepoMan = (IArtifactRepositoryManager)UpdateSiteTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        UpdateSiteTest.assertNotNull((Object)artifactRepoMan);
        URI[] knownRepos = artifactRepoMan.getKnownRepositories(0);
        int i = 0;
        while (i < knownRepos.length) {
            if (siteURI.equals(knownRepos[i])) {
                artifactRepoMan.removeRepository(siteURI);
                knownRepos = artifactRepoMan.getKnownRepositories(0);
                break;
            }
            ++i;
        }
        try {
            artifactRepoMan.loadRepository(site.toURI(), this.getMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("1.0", e);
            return;
        }
        URI[] afterKnownRepos = artifactRepoMan.getKnownRepositories(0);
        UpdateSiteTest.assertTrue((String)"1.1", (afterKnownRepos.length == knownRepos.length + 1 ? 1 : 0) != 0);
    }

    public void testPack200() {
        File output = new File(this.getTempFolder(), UpdateSiteTest.getUniqueString());
        File site = UpdateSiteTest.getTestData("0.1", "/testData/updatesite/packedSiteWithMirror");
        URI siteURI = site.toURI();
        IArtifactRepository repo = null;
        try {
            repo = UpdateSiteTest.getArtifactRepositoryManager().loadRepository(siteURI, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            UpdateSiteTest.fail("0.2", e);
        }
        ArtifactKey key = new ArtifactKey("org.eclipse.update.feature", "test.feature", Version.create((String)"1.0.0"));
        IArtifactDescriptor[] descriptors = repo.getArtifactDescriptors((IArtifactKey)key);
        UpdateSiteTest.assertEquals((int)2, (int)descriptors.length);
        IArtifactDescriptor desc = "packed".equals(descriptors[0].getProperty("format")) ? descriptors[0] : descriptors[1];
        try {
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (FileOutputStream out = new FileOutputStream(output);){
                    IStatus status = repo.getRawArtifact(desc, (OutputStream)out, (IProgressMonitor)new NullProgressMonitor());
                    UpdateSiteTest.assertTrue((boolean)status.isOK());
                    UpdateSiteTest.assertEquals((long)480L, (long)output.length());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                UpdateSiteTest.fail("Failed", e);
                UpdateSiteTest.getArtifactRepositoryManager().removeRepository(siteURI);
            }
        }
        finally {
            UpdateSiteTest.getArtifactRepositoryManager().removeRepository(siteURI);
        }
    }

    public void testMirrors() {
        block11: {
            String testDataLocation = "/testData/updatesite/packedSiteWithMirror";
            File targetLocation = null;
            URI siteURI = UpdateSiteTest.getTestData("0.1", testDataLocation).toURI();
            try {
                try {
                    ArtifactKey key = new ArtifactKey("osgi.bundle", "test.fragment", Version.create((String)"1.0.0"));
                    IArtifactRepository sourceRepo = UpdateSiteTest.getArtifactRepositoryManager().loadRepository(siteURI, this.getMonitor());
                    new OrderedMirrorSelector(sourceRepo, testDataLocation);
                    targetLocation = File.createTempFile("target", ".repo");
                    targetLocation.delete();
                    targetLocation.mkdirs();
                    SimpleArtifactRepository targetRepository = new SimpleArtifactRepository(UpdateSiteTest.getAgent(), "TargetRepo", targetLocation.toURI(), null);
                    IArtifactDescriptor[] descriptors = sourceRepo.getArtifactDescriptors((IArtifactKey)key);
                    IArtifactDescriptor descriptor = null;
                    int i = 0;
                    while (i < descriptors.length && descriptor == null) {
                        if ("packed".equals(descriptors[i].getProperty("format"))) {
                            descriptor = descriptors[i];
                        }
                        ++i;
                    }
                    if (descriptor == null) {
                        UpdateSiteTest.fail((String)"0.3");
                    }
                    RawMirrorRequest mirror = new RawMirrorRequest(descriptor, (IArtifactDescriptor)new ArtifactDescriptor(descriptor), (IArtifactRepository)targetRepository, this.getTransport());
                    mirror.perform(sourceRepo, this.getMonitor());
                    UpdateSiteTest.assertTrue((boolean)mirror.getResult().isOK());
                    UpdateSiteTest.assertTrue((boolean)targetRepository.contains((IArtifactKey)key));
                }
                catch (Exception e) {
                    UpdateSiteTest.fail("0.2", e);
                    if (targetLocation != null) {
                        UpdateSiteTest.delete(targetLocation);
                    }
                    UpdateSiteTest.getArtifactRepositoryManager().removeRepository(siteURI);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (targetLocation != null) {
                    UpdateSiteTest.delete(targetLocation);
                }
                UpdateSiteTest.getArtifactRepositoryManager().removeRepository(siteURI);
                throw throwable;
            }
            if (targetLocation != null) {
                UpdateSiteTest.delete(targetLocation);
            }
            UpdateSiteTest.getArtifactRepositoryManager().removeRepository(siteURI);
        }
    }

    protected class OrderedMirrorSelector
    extends MirrorSelector {
        private URI repoLocation;
        int index;
        MirrorSelector.MirrorInfo[] mirrors;
        IArtifactRepository repo;

        OrderedMirrorSelector(IArtifactRepository repo, String testDataLocation) throws Exception {
            super((IRepository)repo, UpdateSiteTest.this.getTransport());
            this.index = 0;
            this.repo = repo;
            this.setRepoSelector();
            this.getRepoLocation();
            this.mirrors = this.computeMirrors("file:///" + UpdateSiteTest.getTestData("Mirror Location", String.valueOf(testDataLocation) + '/' + (String)repo.getProperties().get("p2.mirrorsURL")).toString().replace('\\', '/'));
        }

        private void setRepoSelector() throws Exception {
            Field delegate = UpdateSiteArtifactRepository.class.getDeclaredField("delegate");
            delegate.setAccessible(true);
            Field mirrorsField = SimpleArtifactRepository.class.getDeclaredField("mirrors");
            mirrorsField.setAccessible(true);
            mirrorsField.set(delegate.get(this.repo), (Object)this);
            Field properties = AbstractRepository.class.getDeclaredField("properties");
            properties.setAccessible(true);
            ((Map)properties.get(delegate.get(this.repo))).put("eclipse.p2.force.threading", String.valueOf(true));
        }

        public synchronized void reportResult(String toDownload, IStatus result) {
        }

        public synchronized boolean hasValidMirror() {
            return this.mirrors != null && this.index < this.mirrors.length;
        }

        public synchronized URI getMirrorLocation(URI inputLocation, IProgressMonitor monitor) {
            return URIUtil.append((URI)this.nextMirror(), (String)this.repoLocation.relativize(inputLocation).getPath());
        }

        private URI nextMirror() {
            Field mirrorLocation = null;
            try {
                mirrorLocation = MirrorSelector.MirrorInfo.class.getDeclaredField("locationString");
                mirrorLocation.setAccessible(true);
                if (this.index < this.mirrors.length) {
                    return URIUtil.makeAbsolute((URI)new URI((String)mirrorLocation.get(this.mirrors[this.index++])), (URI)this.repoLocation);
                }
                return this.repoLocation;
            }
            catch (Exception e) {
                UpdateSiteTest.fail(Double.toString(0.4 + (double)this.index), e);
                return null;
            }
        }

        private synchronized void getRepoLocation() {
            Field locationField = null;
            try {
                locationField = UpdateSiteArtifactRepository.class.getDeclaredField("location");
                locationField.setAccessible(true);
                this.repoLocation = (URI)locationField.get(this.repo);
            }
            catch (Exception e) {
                UpdateSiteTest.fail("0.3", e);
            }
        }

        private MirrorSelector.MirrorInfo[] computeMirrors(String mirrorsURL) {
            Document document;
            block5: {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                document = builder.parse(mirrorsURL);
                if (document != null) break block5;
                return null;
            }
            try {
                NodeList mirrorNodes = document.getElementsByTagName("mirror");
                int mirrorCount = mirrorNodes.getLength();
                MirrorSelector.MirrorInfo[] infos = new MirrorSelector.MirrorInfo[mirrorCount + 1];
                int i = 0;
                while (i < mirrorCount) {
                    Element mirrorNode = (Element)mirrorNodes.item(i);
                    String infoURL = mirrorNode.getAttribute("url");
                    infos[i] = new MirrorSelector.MirrorInfo(infoURL, i);
                    ++i;
                }
                infos[mirrorCount] = new MirrorSelector.MirrorInfo(this.repoLocation.toString(), mirrorCount);
                return infos;
            }
            catch (Exception e) {
                if (mirrorsURL != null && (mirrorsURL.startsWith("http://") || mirrorsURL.startsWith("https://") || mirrorsURL.startsWith("file://") || mirrorsURL.startsWith("ftp://") || mirrorsURL.startsWith("jar://"))) {
                    UpdateSiteTest.fail("Error processing mirrors URL: " + mirrorsURL, e);
                }
                return null;
            }
        }
    }
}

