/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.util.Random;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test {
    private static final int RANDOM_ITERATIONS = 1000;
    private static final String decoded1 = "sample^^*";
    private static final String encoded1 = "c2FtcGxlXl4q";
    private static final String decoded2 = "lazy frog jumped over sleeping dog";
    private static final String encoded2 = "bGF6eSBmcm9nIGp1bXBlZCBvdmVyIHNsZWVwaW5nIGRvZw==";
    private static final byte[] decoded3;
    private static final String encoded3 = "BQAADCABf/8=";
    private static final byte[] decoded4;
    private static final String encoded4 = "";
    private static final String decoded5 = "1.234";
    private static final String encoded5 = "M\u0005S4y\tM\n\rzQ=\r\n";
    private static final String decoded6 = "a";
    private static final String encoded6 = "YQ==";

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[3] = 12;
        byArray[4] = 32;
        byArray[5] = 1;
        byArray[6] = 127;
        byArray[7] = -1;
        decoded3 = byArray;
        decoded4 = new byte[0];
    }

    @Test
    public void testHandCoded() {
        String encoded = EncodingUtils.encodeBase64((byte[])decoded1.getBytes());
        Assert.assertEquals((Object)encoded1, (Object)encoded);
        byte[] bytes = EncodingUtils.decodeBase64((String)encoded2);
        String decoded = new String(bytes);
        Assert.assertEquals((Object)decoded2, (Object)decoded);
        String testZeroes = EncodingUtils.encodeBase64((byte[])decoded3);
        Assert.assertEquals((Object)encoded3, (Object)testZeroes);
        byte[] roundtripBytes = EncodingUtils.decodeBase64((String)testZeroes);
        this.compareArrays(decoded3, roundtripBytes);
        byte[] bytesInvalidChars = EncodingUtils.decodeBase64((String)encoded5);
        String decodedInvalidChars = new String(bytesInvalidChars);
        Assert.assertEquals((Object)decoded5, (Object)decodedInvalidChars);
        String shortSample = EncodingUtils.encodeBase64((byte[])decoded6.getBytes());
        Assert.assertEquals((Object)encoded6, (Object)shortSample);
        Assert.assertEquals((Object)decoded6, (Object)new String(EncodingUtils.decodeBase64((String)shortSample)));
    }

    @Test
    public void testEdge() {
        Assert.assertNull((Object)EncodingUtils.encodeBase64(null));
        Assert.assertNull((Object)EncodingUtils.decodeBase64(null));
        String encoded = EncodingUtils.encodeBase64((byte[])decoded4);
        Assert.assertNotNull((Object)encoded);
        Assert.assertEquals((Object)encoded4, (Object)encoded);
        byte[] decoded = EncodingUtils.decodeBase64((String)encoded);
        this.compareArrays(decoded4, decoded);
    }

    @Test
    public void testRandom() {
        Random generator = new Random(System.currentTimeMillis());
        int i = 0;
        while (i < 1000) {
            int length = 100 + generator.nextInt(900);
            byte[] bytes = new byte[length];
            generator.nextBytes(bytes);
            String encoded = EncodingUtils.encodeBase64((byte[])bytes);
            byte[] decoded = EncodingUtils.decodeBase64((String)encoded);
            this.compareArrays(bytes, decoded);
            ++i;
        }
    }

    private void compareArrays(byte[] array1, byte[] array2) {
        Assert.assertNotNull((Object)array1);
        Assert.assertNotNull((Object)array2);
        Assert.assertEquals((long)array1.length, (long)array2.length);
        int i = 0;
        while (i < array1.length) {
            Assert.assertEquals((long)array1[i], (long)array2[i]);
            ++i;
        }
    }
}

