/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.junit.Assert;
import org.junit.Test;

public class ManualTest {
    private static final String JAVA_MODULE_ID = "org.eclipse.equinox.security.javaCrypt";
    private final String passwordSample = "uYTIU689_~@@/";
    private final String loginSample = "cheburashka";

    @Test
    public void testBasic() {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            for (Map.Entry<Object, Object> entry : providers[i].entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || key.indexOf(32) != -1) continue;
                if (key.startsWith("Cipher.")) {
                    String cipher = key.substring(7);
                    System.out.println("[cypher] " + cipher);
                }
                if (!key.startsWith("SecretKeyFactory.")) continue;
                String keyFactory = key.substring(17);
                System.out.println("[keyFactory] " + keyFactory);
            }
            ++i;
        }
    }

    @Test
    public void testJavaModule() throws IOException, StorageException {
        HashMap<String, String> options = new HashMap<String, String>(1);
        options.put("org.eclipse.equinox.security.storage.requiredID", JAVA_MODULE_ID);
        ISecurePreferences storage = SecurePreferencesFactory.open(null, options);
        ISecurePreferences node = storage.node("/cvs/account1");
        node.put("login", "cheburashka", true);
        node.put("password", "uYTIU689_~@@/", true);
        Assert.assertEquals((Object)"cheburashka", (Object)node.get("login", null));
        Assert.assertEquals((Object)"uYTIU689_~@@/", (Object)node.get("password", null));
    }
}

