/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.equinox.internal.security.storage.StorageUtils;
import org.eclipse.equinox.internal.security.tests.storage.StorageAbstractTest;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlashEncodeTest
extends StorageAbstractTest {
    private static final String[] decodedSlash = new String[]{"root", "ro/ot", "/root", "root/", "ro/ot/me", "ro//ot"};
    private static final String[] encodedSlash = new String[]{"root", "ro\\2fot", "\\2froot", "root\\2f", "ro\\2fot\\2fme", "ro\\2f\\2fot"};
    private static final String[] decodedBackSlash = new String[]{"ro\\ot", "\\root", "root\\", "ro\\ot\\me", "ro\\\\ot"};
    private static final String[] encodedBackSlash = new String[]{"ro\\5cot", "\\5croot", "root\\5c", "ro\\5cot\\5cme", "ro\\5c\\5cot"};
    private static final String[] decodedMixSlash = new String[]{"r/o\\ot", "r\\o/ot", "/\\root", "root\\/", "\\5cro\\2f ot"};
    private static final String[] encodedMixSlash = new String[]{"r\\2fo\\5cot", "r\\5co\\2fot", "\\2f\\5croot", "root\\5c\\2f", "\\5c5cro\\5c2f ot"};

    @Test
    public void testForwardSlash() {
        int i = 0;
        while (i < decodedSlash.length) {
            String tmp = EncodingUtils.encodeSlashes((String)decodedSlash[i]);
            Assert.assertEquals((Object)encodedSlash[i], (Object)tmp);
            Assert.assertEquals((Object)decodedSlash[i], (Object)EncodingUtils.decodeSlashes((String)tmp));
            ++i;
        }
    }

    @Test
    public void testBackwardSlash() {
        int i = 0;
        while (i < decodedBackSlash.length) {
            String tmp = EncodingUtils.encodeSlashes((String)decodedBackSlash[i]);
            Assert.assertEquals((Object)encodedBackSlash[i], (Object)tmp);
            Assert.assertEquals((Object)decodedBackSlash[i], (Object)EncodingUtils.decodeSlashes((String)tmp));
            ++i;
        }
    }

    @Test
    public void testMixSlash() {
        int i = 0;
        while (i < decodedMixSlash.length) {
            String tmp = EncodingUtils.encodeSlashes((String)decodedMixSlash[i]);
            Assert.assertEquals((Object)encodedMixSlash[i], (Object)tmp);
            Assert.assertEquals((Object)decodedMixSlash[i], (Object)EncodingUtils.decodeSlashes((String)tmp));
            ++i;
        }
    }

    @Test
    public void testEdge() {
        Assert.assertNull((Object)EncodingUtils.encodeSlashes(null));
        Assert.assertNull((Object)EncodingUtils.decodeSlashes(null));
        String encoded = EncodingUtils.encodeSlashes((String)"");
        Assert.assertNotNull((Object)encoded);
        Assert.assertEquals((Object)"", (Object)encoded);
    }

    protected Map<String, Object> getOptions() {
        return this.getOptions("password1");
    }

    @Test
    public void testPreferencesWithSlashes() throws IOException, StorageException {
        URL location = this.getStorageLocation();
        Assert.assertNotNull((Object)location);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions());
        String safePath = EncodingUtils.encodeSlashes((String)"ro/ot");
        ISecurePreferences node = preferences.node(safePath);
        node.put("password", "test", true);
        Assert.assertFalse((boolean)preferences.nodeExists("ro"));
        Assert.assertFalse((boolean)preferences.nodeExists("ro/ot"));
        Assert.assertTrue((boolean)preferences.nodeExists(safePath));
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(location, this.getOptions());
        String[] children = preferences.childrenNames();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)children.length, (long)1L);
        ISecurePreferences nodeRet = preferences.node(children[0]);
        String absolutePath = EncodingUtils.decodeSlashes((String)nodeRet.absolutePath());
        Assert.assertEquals((Object)"/ro/ot", (Object)absolutePath);
        Assert.assertEquals((Object)"test", (Object)nodeRet.get("password", null));
        StorageUtils.delete((URL)location);
    }
}

