/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.apt.tests.plugin.AptTestsPlugin;
import org.eclipse.jdt.core.IJavaProject;

public class AnnotationValueTests
extends APTTestBase {
    public AnnotationValueTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AnnotationValueTests.class);
    }

    private IProject setupTest() throws Exception {
        IJavaProject jproj = this.getCurrentJavaProject();
        jproj.setOption("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        return jproj.getProject();
    }

    private void addTriggerSource() {
        IPath srcRoot = this.getSourcePath();
        env.addClass(srcRoot, "trigger", "MyTrigger", "package trigger; \n\npublic @interface MyTrigger {}");
        env.addClass(srcRoot, "trigger", "Trigger", "package trigger; \n\n@MyTrigger \npublic class Trigger {}");
    }

    public void testAnnotationValueProcessor() throws Exception {
        IProject project = this.setupTest();
        File jar = TestUtil.getFileInPlugin(AptTestsPlugin.getDefault(), (IPath)new Path("/resources/question.jar"));
        String path = jar.getAbsolutePath();
        env.addExternalJar(project.getFullPath(), path);
        this.addTriggerSource();
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        AnnotationValueTests.assertTrue((boolean)ProcessorTestStatus.processorRan());
        AnnotationValueTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }
}

